package com.digiwin.athena.adt.agileReport.config;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @version 1.0
 * @Author: Sun Hong
 * @Date: 2024/6/3 15:22
 * @Description : 实现容器注册
 */
@Component
public class HandlerProcessor implements ApplicationContextAware {
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        //获取所有策略注解的Bean
        Map<String, Object> map = applicationContext.getBeansWithAnnotation(AgileDataType.class);
        map.forEach((k,v)->{
            Class<AgileDataProcessService> strategyClass = (Class<AgileDataProcessService>) v.getClass();
            AgileDataEnum type = strategyClass.getAnnotation(AgileDataType.class).value();
            //将class加入map中,type作为key
            AgileDataHandlerProcessor.SERVICE_HAND_MAP.put(type,strategyClass);
        });
    }
}
