package com.digiwin.athena.adt.agileReport.config;

import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 13:22
 * @Description:
 */
@Component
public class SchemaDataHandlerProcessor {


    @Autowired
    private ApplicationContext applicationContext;

    protected static final Map<SchemaDataEnum,Class<SchemaDataProcessService>> SERVICE_HAND_MAP = new HashMap<>(2);

    public SchemaDataProcessService getEnumServiceByType(Enum type){
        Class<SchemaDataProcessService> strategyClass = SERVICE_HAND_MAP.get(type);
        if(strategyClass==null) {
            throw new IllegalArgumentException("没有找到对应的实现");
        }
        //从容器中获取对应的策略Bean
        return applicationContext.getBean(strategyClass);
    }

}
