package com.digiwin.athena.adt.agileReport.constant;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @version 1.0
 * @Author: Sun Hong
 * @Date: 2024/6/3 15:22
 * @Description: 问句枚举类
 */
@Getter
public enum AgileDataEnum {

    /**
     * 指标
     */
    TARGET("target", "指标"),


    /**
     * 设计器
     */
    DESIGNER("designer", "设计器"),


    /**
     * 指标
     */
    METRIC("metric", "指标2"),

    /**
     * mock穿透
     */
    MOCK("mock", "mock穿透"),

    /**
     * lite
     */
    SPECIAL("special", "lite"),

    /**
     * 数据集
     */
    DATASET("dataset", "数据集"),

    /**
     * PPT分析规划
     */
    PPT_ANALYZE("ppt_Analyze", "PPT分析规划"),

    /**
     * PPT 问数
     */
    PPT_PROCESS("ppt_process", "PPT问数"),

    /**
     * 分析师
     */
    AUTODATA_REPORT("autoData_report", "分析师生成报表"),

    /**
     * 对话看板分析
     */
    AI_BOARD_ANALYZE("board_analyze", "对话看板分析"),

    /**
     * 对话看板分析
     */
    AI_BOARD_QUESTION("board_question", "对话看板问句");

    /**
     * 类型
     */
    private final String code;

    /**
     * desc
     */
    private final String name;

    AgileDataEnum (String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static AgileDataEnum queryTypeEnumByCode(String code){
        for (AgileDataEnum typeEnum:values()){
            if (StringUtils.isNotEmpty(code) && typeEnum.code.equals(code)){
                return typeEnum;
            }
        }
        return null;
    }
}
