package com.digiwin.athena.adt.agileReport.constant;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author: SunHong
 * @Date: 2024/8/15 10:36
 * @Description: adt 消息策略类型枚举
 */
@Getter
public enum AgileDataSourceEnum {

    DEBUG_MODEL("debugModel", "调试模式","1"),

    QUERY("query", "娜娜问句","2"),

    PANEL("panel", "数据看板","3"),

    SUBSCRIBER("subscriber", "数据订阅","4");


    /**
     * 类型
     */
    private final String code;

    /**
     * desc
     */
    private final String name;


    private final String value;

    AgileDataSourceEnum(String code, String name, String value) {
        this.code = code;
        this.name = name;
        this.value = value;
    }

    public static AgileDataSourceEnum queryTypeEnumByCode(String code){
        for (AgileDataSourceEnum typeEnum:values()){
            if (StringUtils.isNotEmpty(code) && typeEnum.code.equals(code)){
                return typeEnum;
            }
        }
        return null;
    }

}
