package com.digiwin.athena.adt.agileReport.constant;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author: SunHong
 * @Date: 2024/8/15 10:36
 * @Description: adt 消息策略类型枚举
 */
@Getter
public enum AthenaMessageEnum {

    DEBUG("debug", "debug模式","2"),
    //0 1 3 常规入口
    DESIGNER("designer", "设计器","3"),

    PARAM("param", "param模式","4"),

    METRIC("metric", "指标2","5"),

    PANEL("panel", "数据看板","6"),

    TARGET("target", "指标1","7"),

    MOCK("mock", "mock穿透","8"),

    SPECIAL("special", "生成式场景","9"),

    SPECIAL_LITE("special_lite", "生成式场景lite","10"),

    METRIC_DEBUG("metric_debug", "指标debug模式","11"),

    PPT_ANALYZE("ppt_analyze", "PPT分析规划","12"),

    PPT_GENERATE("ppt_generate", "PPT生成","13"),

    AUTODATA_REPORT("autoData_report", "分析师生成报告","14"),

    AUTO_DATA_QUESTION("auto_data_report", "分析师问答","15"),

    AI_BOARD_QUESTION("ai_board_question", "对话看板问答","16"),

    ATTRIBUTION_SUMMARY("attribution_summary", "归因总结","17");


    /**
     * 类型
     */
    private final String code;

    /**
     * desc
     */
    private final String name;


    private final String value;

    AthenaMessageEnum (String code, String name,String value) {
        this.code = code;
        this.name = name;
        this.value = value;
    }

    public static AthenaMessageEnum queryTypeEnumByCode(String code){
        for (AthenaMessageEnum typeEnum:values()){
            if (StringUtils.isNotEmpty(code) && typeEnum.code.equals(code)){
                return typeEnum;
            }
        }
        return null;
    }

}
