package com.digiwin.athena.adt.agileReport.constant;


import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import lombok.Getter;

/**
 * 卡片类型
 *
 * @author majianfu
 * @date 2023/4/13
 * @since
 */
public enum CardTypeEnum {
    /**
     * 任务卡
     */
    TASK_CARD(1),
    /**
     * 项目卡
     */
    PROJECT_CARD(2);

    /**
     * 卡片类型
     */
    @Getter
    private int type;

    CardTypeEnum(int type) {
        this.type = type;
    }

    /**
     * 检验卡片类型
     *
     * @param cardType
     * @throws BusinessException
     */
    public static void checkCardType(int cardType) {
        for (CardTypeEnum cardTypeEnum : CardTypeEnum.values()) {
            if (cardTypeEnum.getType() == cardType) {
                return;
            }
        }

        String errMsg = SpringUtil.getBean(MessageUtils.class).getMessage("exception.support.card.type");
        throw BusinessException.create(errMsg);
    }

}
