package com.digiwin.athena.adt.agileReport.constant;

import com.alibaba.nacos.api.exception.NacosException;
import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atmc.http.domain.calendar.model.DuplicateKeyException;
import com.digiwin.athena.atmc.http.domain.calendar.model.PermissionException;
import lombok.Getter;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 错误码定义类
 */
public enum ErrorCodeEnum {

    /**
     * 调用中间价报错（中间价没有封装规范格式的错误码）
     * 第3码用于区分不同的中间件，第4码用于表示该组件不同的API
     *
     * P_ADT_AAM_ERROR("P.ADT.901.0001","调aam的api：报错"),
     * P_ADT_ADE_ERROR("P.ADT.902.0001","调ade的api：报错"),
     * P_ADT_CHATBI_ERROR("P.ADT.903.0001","调chatbi的api：报错"),
     * P_ADT_KM_ERROR("P.ADT.904.0001","调km的api：报错"),
     * P_ADT_SEMC_ERROR("P.ADT.905.0001","调semc的api：报错"),*
     */

    //调用aam报错
    AAM_UPLOAD_AGILEDATA_FAIL("P.ADT.901.0001","调用aam的uploadAgileReport接口上传文档失败"),
    AAM_GET_AGILEDATA_FAIL("P.ADT.901.0002","调用aam的getAgileReportInfo接口获取文档中心敏捷数据失败"),
    AAM_DELETE_AGILEDATA_FAIL("P.ADT.901.0003","调用aam的deleteAgileReportInfo接口删除敏捷报表数据失败"),
    AAM_BATCHDELETE_AGILEDATA_FAIL("P.ADT.901.0004","调用aam的delete批量删除敏捷报表数据失败"),

    //调用uibot报错
    UIBOT_DATA_AGILEDATA_FAIL("P.ADT.901.0005","调用uibot的补偿数据接口失败"),

    //调用ade报错
    ADE_GET_SNAPDATA_FAIL("P.ADT.902.0001","请求ade传入sdScencDTO获取敏捷数据snapShotDTO失败"),
    ADE_REALTIME_SNAPDATA_FAIL("P.ADT.902.0002","503 请求ade失败"),
    ADE_REALTIME_SQL_FAIL("P.ADT.902.0003","获取查询方案的SQL失败"),

    ADE_REALTIME_TIME_OUT_FAIL("P.ADT.902.0004","503 请求ade超时"),

    //调用chatbi报错
    CHATBI_QUERY_FAIL("P.ADT.903.0001","传入文本信息获取chatBI返回结果失败,入参{text:帮我预测天气}"),

    //调用km报错
    KM_GET_TITLE_FAIL("P.ADT.904.0001","根据code获取snapData的title失败"),

    //调用km报错
    KM_GET_CODE_FAIL("P.ADT.904.0002","获取场景code失败"),

    KM_GET_TIME_OUT_FAIL("P.ADT.904.0003","调用km接口获取信息超时"),

    //调用semc报错
    SEMC_SEND_MESSAGE_FAIL("P.ADT.905.0001","发送sendMessageDTO失败"),

    //任务、项目
    DMCID_CAN_NOT_FIND("P.ADT.500.0001","数据库中未查询到DmcId"),
    WHO_IS_EMPTY("P.ADT.500.0002","who数据为空!"),
    DELETE_SNAP_IS_EMPTY("P.ADT.500.0003","查不到该snapdata"),
    USERINFO_IS_EMPTY("P.ADT.500.0004","用户信息不存在"),
    CAC_REALTIME_FAIL("P.ADT.905.0001","请求cac超时"),
    CAC_GET_FAIL("P.ADT.905.0002","请求cac失败"),
    CAC_REALTIME_DECREASE_FAIL("P.ADT.905.0003","请求cac超时"),
    CAC_DECREASE_FAIL("P.ADT.905.0004","请求cac失败"),

    TDD_REALTIME_FAIL("P.ADT.906.0001","请求tdd超时"),
    TDD_GET_FAIL("P.ADT.906.0002","请求tdd失败"),

    ECHO_REALTIME_FAIL("P.ADT.907.0001","请求echo超时"),
    ECHO_GET_FAIL("P.ADT.907.0002","请求echo失败"),

    KM_GET_PURCHASE_FAIL("P.ADT.908.0001","根据token获取km 应用失败"),

    IAM_USER_INFO_FAIL("P.ADT.910.0001","请求IAM 获取用户信息失败"),

    UPLOAD_DMC_ERROR("P.ADT.911.0001","请求DMC 上传附件失败 "),

    TRANS_DATA_ERROR("P.ADT.921.0001","获取转换数据失败");


    /**
     * 错误码
     */
    @Getter
    private String errCode;

    /**
     * 错误描述
     */
    @Getter
    private String errMsg;

    private static MessageSource messageSource;

    static {
        ErrorCodeEnum.messageSource = SpringUtil.getBean(MessageSource.class);
    }

    ErrorCodeEnum(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     *
     * @return
     */
    public BusinessException getBusinessException() {
        return BusinessException.create(this.getErrCode(), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()));
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @param errorTypeEnum 错误类型枚举
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(ErrorTypeEnum errorTypeEnum) {
        return BusinessException.create(this.getErrCode(), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()), errorTypeEnum.getValue());
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     * args：message后面需要带的参数
     *
     * @return
     */
    public BusinessException getBusinessExceptionWithArgs(Object... paras) {
        return BusinessException.create(this.getErrCode(), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), paras, LocaleContextHolder.getLocale()));
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(String errorMessage) {
        return BusinessException.create(this.getErrCode(), errorMessage);
    }


    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     *
     * @return
     */
    public PermissionException getPermissionException() {
        return new PermissionException(Integer.parseInt(this.getErrCode()), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()));
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     *
     * @return
     */
    public PermissionException getPermissionException(String errorMsg) {
        return new PermissionException(Integer.parseInt(this.getErrCode()), errorMsg);
    }


}
