package com.digiwin.athena.adt.agileReport.constant;

import lombok.Getter;

/**
 * @Author: SunHong
 * @Date: 2024/12/18 11:35
 * @Description:
 */
@Getter
public enum TroubleToolCodeEnum {

    ADT_901_0101("P.ADT.901.0101","ADT入参解析失败，可能是版本或兼容问题","ADT解析入参失败-请检查请求入参是否正确"),
    ADT_901_0102("P.ADT.901.0102","ADT入参解析失败，可能是版本或兼容问题","ADT解析入参失败-请检查请求入参是否正确"),
    ADT_901_0103("P.ADT.910.0103","语义调用超时","请联系平台管理员"),
    ADT_901_0104("P.ADT.910.0104","语义调用失败","请联系平台管理员"),
    ADT_901_0105("P.ADT.910.0105","语义调用超时","请联系平台管理员"),
    ADT_901_0106("P.ADT.910.0106","语义调用失败","请联系平台管理员"),
    ADT_901_0107("U.ADT.910.0107","解析debug入參格式錯誤","请使用正确的debug调用参数格式:【*debug**S202405210005**templateCode:ranking**target:shipment*\" +\n" +
            "                            \"**exDimension:ITEMNAME**time:TRANSACTIONDATE|2024-01-01#2024-12-31**sort:SHIPMENTAMT_sum|desc*\" +\n" +
            "                            \"*dimension:ITEMNAME**limit:3*】"),
    ADT_901_0108("U.ADT.910.0108","解析param入參格式錯誤","请使用正确的param调用参数格式:【*param**S202405210005**templateCode:ranking**target:shipment*\\\" +\\n\" +\n" +
            "            \"                            \\\"**exDimension:ITEMNAME**time:TRANSACTIONDATE|2024-01-01#2024-12-31**sort:SHIPMENTAMT_sum|desc*\\\" +\\n\" +\n" +
            "            \"                            \\\"*dimension:ITEMNAME**limit:3*】"),
    ADT_901_0109("U.ADT.910.0109","解析metric-debug入參格式錯誤","请使用正确的metric-debug调用参数格式:【*metric**S202405210005**templateCode:ranking**target:shipment*\\\" +\\n\" +\n" +
            "            \"                            \\\"**exDimension:ITEMNAME**time:TRANSACTIONDATE|2024-01-01#2024-12-31**sort:SHIPMENTAMT_sum|desc*\\\" +\\n\" +\n" +
            "            \"                            \\\"*dimension:ITEMNAME**limit:3*】"),
    ADT_901_0110("U.ADT.910.0110","解析test入參格式錯誤","请使用正确的test调用参数格式:【*test**S202405210005**templateCode:ranking**target:shipment*\\\" +\\n\" +\n" +
            "            \"                            \\\"**exDimension:ITEMNAME**time:TRANSACTIONDATE|2024-01-01#2024-12-31**sort:SHIPMENTAMT_sum|desc*\\\" +\\n\" +\n" +
            "            \"                            \\\"*dimension:ITEMNAME**limit:3*】"),
    ADT_901_0111("U.ADT.910.0111","解析pr-debug入參格式錯誤","请使用正确的pr-debug调用参数格式:【*pr-debug**S202405210005**templateCode:ranking**target:shipment*\\\" +\\n\" +\n" +
            "            \"                            \\\"**exDimension:ITEMNAME**time:TRANSACTIONDATE|2024-01-01#2024-12-31**sort:SHIPMENTAMT_sum|desc*\\\" +\\n\" +\n" +
            "            \"                            \\\"*dimension:ITEMNAME**limit:3*】"),
    ADT_901_0112("P.ADT.910.0112","解析指标信息失败,可能是返回的執行計劃有誤","ADT解析入参失败,请检查入参是否正确"),
    ADT_901_0113("P.ADT.910.0113","解析场景信息失败,可能是返回的执行计划有误","ADT解析入参失败,请检查入参是否正确"),
    ADT_901_0114("P.ADT.910.0114","语义返回多应用信息错误","请联系平台管理员"),
    ADT_901_0115("P.ADT.910.0115","语义返回多目标信息错误","请联系平台管理员"),
    ADT_901_0116("P.ADT.910.0116","语义返回多场景信息错误","请联系平台管理员"),
    ADT_901_0117("P.ADT.910.0117","ADT调用CAC扣减流程次数失败","请检查设计器配置的计费流量ID是否正确"),
    ADT_901_0118("P.ADT.910.0118","CAC调用超时","请联系平台管理员"),
    ADT_901_0119("P.ADT.910.0119","CAC调用错误","请联系平台管理员"),
    ADT_901_0120("P.ADT.910.0120","ADT调用ECHO扣减体验次数失败","请联系平台管理员"),
    ADT_901_0121("P.ADT.910.0121","ADE调用失败","请联系平台管理员"),
    ADT_901_0122("P.ADT.910.0122","ADE调用超时","请联系平台管理员"),
    ADT_901_0123("P.ADT.910.0123","解析DEBUG信息失败","请联系平台管理员"),
    ADT_901_0124("P.ADT.910.0124","ECHO调用失败","请联系平台管理员"),
    ADT_901_0125("P.ADT.910.0125","ECHO调用超时","请联系平台管理员"),
    ADT_901_0126("P.ADT.910.0126","ADT存储快照失败，快照信息","请联系平台管理员"),
    ADT_901_0127("P.ADT.910.0127","AAM文档中心调用失败","请联系平台管理员"),
    ADT_901_0128("P.ADT.910.0128","AAM文档中心调用超时","请联系平台管理员"),
    ADT_901_0129("P.ADT.910.0129","解析数据集信息失败,可能是返回的執行計劃有誤","ADT解析入参失败,请检查入参是否正确");

    //通知类
    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误描述
     */
    private String errMsg;

    private String suggestion;

    TroubleToolCodeEnum(String errCode, String errMsg,String suggestion) {
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.suggestion = suggestion;

    }

}
