package com.digiwin.athena.adt.agileReport.controller;

import com.digiwin.athena.adt.agileReport.service.ChartSnapshotService;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataChartSnapshot;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

@RestController
@RequestMapping("/api/ai/agileData/chartSnapshot")
public class ChartSnapshotController {

    @Autowired
    private ChartSnapshotService chartSnapshotService;

    @PostMapping("/save")
    public ResponseEntity<?> save(@RequestBody @Validated AgileDataChartSnapshot snapshot,
                                  @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        chartSnapshotService.saveSnapshot(snapshot);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/get")
    public ResponseEntity<?> get(@RequestParam("snapshotId") @NotBlank String snapshotId,
                                 @RequestParam("chartType") @NotBlank String chartType,
                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(chartSnapshotService.getBySnapshotId(snapshotId, chartType));
    }
}
