package com.digiwin.athena.adt.agileReport.controller.assist;

import com.digiwin.athena.adt.agileReport.service.AgileDataAssistTroubleService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.google.common.eventbus.AsyncEventBus;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.Executor;

/**
 * 辅助排查问题
 */
@RestController
@RequestMapping(value = "/api/ai/assist")
public class AgileDataAssistTroubleController {

    @Autowired
    private AsyncEventBus asyncEventBus;

    @Autowired
    private AgileDataAssistTroubleService agileDataAssistTroubleService;

    /**
     * 获取ADE入参
     * @param request
     * @param message
     * @param user
     * @return
     */
    @GetMapping("/data/getADEParams/{message}")
    public ResponseEntity<?> getSnapShotData(HttpServletRequest request, @PathVariable("message") String message,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return getData(request,message,null,user);
    }


    @Deprecated
    @PostMapping("/data/getADEParams")
    public ResponseEntity<?> getADEParams(HttpServletRequest request, @RequestBody Map<String,Object> params,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String message = MapUtils.getString(params,"message");
        String sceneCode = MapUtils.getString(params,"sceneCode");
        return getData(request,message,sceneCode,user);
    }

    public ResponseEntity<?> getData(HttpServletRequest request,String message,String sceneCode,AuthoredUser user){
        return ResponseEntityWrapper.wrapperOk(agileDataAssistTroubleService
                .getAssistTroubleData(request, message, sceneCode, user));
    }

    /**
     * 监控当前eventbus
     *
     * @return
     */
    @GetMapping(value = "/monitor/eventBus", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> monitorEventBus() {
        Map<String, Object> monitorMap = new HashMap<>();
        try {
            Field executorField = asyncEventBus.getClass().getSuperclass().getDeclaredField("executor");
            executorField.setAccessible(true);

            Executor executor = (Executor) executorField.get(asyncEventBus);
            Field[] fields = executor.getClass().getDeclaredFields();
            for (Field temp : fields) {
                temp.setAccessible(true);
                monitorMap.put(temp.getName(), temp.get(executor).toString());
            }
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return ResponseEntityWrapper.wrapperOk(monitorMap);
    }


}
