package com.digiwin.athena.adt.agileReport.controller.assist;

import com.digiwin.athena.adt.agileReport.service.AgileDataPageHooksService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping(value = "/api/ai/pageView")
public class AgileDataPageHooksController {

    @Autowired
    private AgileDataPageHooksService agileDataPageHooksService;

    @PostMapping(value = "/hooks/create")
    public ResponseEntity<?> createAgileDataPageHooks(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                                      @RequestBody Map<String,Object> params) {
        return ResponseEntityWrapper.wrapperOk(agileDataPageHooksService.createAgileDataPageHooks(user,params));
    }

    @GetMapping(value = "/hooks/query")
    public ResponseEntity<?> queryAgileDataPageHooks(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                                     @RequestParam(value = "type", required = false) String type) {
        return ResponseEntityWrapper.wrapperOk(agileDataPageHooksService.queryAgileDataPageHooks(user,type));
    }

}
