package com.digiwin.athena.adt.agileReport.controller.cost;

import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.domain.po.AgileDataCostDetail;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2025/3/31 9:09
 * @Description: 敏数对接计费中心
 */
@RestController
@RequestMapping(value = "/api/ai/agile/cost")
public class AgileDataCostController {

    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    @PostMapping("/insert")
    public ResponseEntity<?> insert(@RequestBody AgileDataCostDetail agileDataCostDetail,
                                    @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        agileDataCostDetailService.insert(agileDataCostDetail);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/update")
    public ResponseEntity<?> update(@RequestBody AgileDataCostDetail agileDataCostDetail,
                                    @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        agileDataCostDetailService.update(agileDataCostDetail);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/delete")
    public ResponseEntity<?> delete(@RequestBody AgileDataCostDetail agileDataCostDetail,
                                    @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        agileDataCostDetailService.delete(agileDataCostDetail);
        return ResponseEntityWrapper.wrapperOk();
    }
}
