package com.digiwin.athena.adt.agileReport.controller.dataset;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileTableDataReqDTO;
import com.digiwin.athena.adt.agileReport.service.AgileDataTableDataService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2025/5/21 13:18
 * @Description: 数据集请求
 */
@RestController
@RequestMapping(value = "/api/ai/v2/table")
public class AgileDataTableDataController {


    @Autowired
    private AgileDataTableDataService agileDataTableDataService;

    /**
     * 数据集列表
     * @param reqDTO Req
     * @param user u
     * @return res
     */
    @PostMapping("/getTableList")
    public ResponseEntity<?> getTableList(@RequestBody @Validated AgileTableDataReqDTO reqDTO,
                                    @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataTableDataService.getTableList(user,reqDTO));
    }

    /**
     * 数据集预览
     * @param reqDTO req
     * @param user u
     * @return res
     */
    @PostMapping("/getTablePreviewData")
    public ResponseEntity<?> getTablePreviewData(@RequestBody @Validated AgileTableDataReqDTO reqDTO,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataTableDataService.getTablePreviewData(user,reqDTO));
    }

}
