package com.digiwin.athena.adt.agileReport.controller.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
public class AgileDataFeedBackDTO {

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 消息ID
     */
    private Long generateSerialNo;

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 问题
     */
    private String question;

    /**
     * 操作行为：0.点赞 1.点踩
     */
    private Integer feedbackType;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 反馈类型，0.系统无法回答 1.用户反馈意见
     */
    private Integer backType;

    /**
     * 系统错误信息
     */
    private String errorMsg;

    /**
     * 用户意见
     */
    private String answerOpinion;

    /**
     * 勾选项
     */
    private String checkOpinions;

    /**
     * 反馈信息
     */
    private String backContent;

    /**
     * 扩展信息
     */
    private Map<String,Object> extendInfo;

}
