package com.digiwin.athena.adt.agileReport.controller.dto;

import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import lombok.Data;
import lombok.extern.log4j.Log4j;
import lombok.extern.log4j.Log4j2;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: SunHong
 * @Date: 2025/8/7 10:44
 * @Description:
 */
@Data
@Log4j2
public class AnalysisFluctuateReqDTO implements Serializable {

    private String snapshotId;

    private Map<String,Object> processStreamData;

    private String question;

    private List<String> datasetIds;

    private Map<String ,Object> metric;

    private List<Map<String ,Object>> dimension;

    private String step;

    private Map<String ,Object> solutionStep;

    private String appCode;

    private String lang;

    private Map<String,Object> orgOutPutSql;

    private String questionDate;

    private List<Map<String ,Object>> pullData;

    public static AnalysisFluctuateReqDTO builderQuery(AnalysisFluctuateReqDTO req, SnapShotDTO orgSnapshotDTO) {
        AnalysisFluctuateReqDTO res = new AnalysisFluctuateReqDTO();
        try {
            Map<String ,Object> step = new HashMap<>();
            if(Objects.nonNull(req.getProcessStreamData())
                    && Objects.nonNull(req.getProcessStreamData().get("questionWay"))){
                step = (Map<String, Object>) req.getProcessStreamData().get("questionWay");
            }
            List<String> datasetIdList = orgSnapshotDTO.getContext().getBizParams().getDatasetList()
                    .stream()
                    .map(map -> String.valueOf(map.get("datasetId")))
                    .collect(Collectors.toList());
            LocalDateTime questionDate = orgSnapshotDTO.getContext().getBizParams().getRequestTime();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

            res.setDatasetIds(datasetIdList);
            res.setStep(String.valueOf(step.get("content")));
            res.setQuestion(orgSnapshotDTO.getContext().getBizParams().getQuestion());
            res.setQuestionDate(questionDate.format(formatter));
            res.setOrgOutPutSql(req.getOrgOutPutSql());
            res.setDimension(req.getDimension());
            res.setMetric(req.getMetric());
        }catch (Exception e){
            log.error("数据波动转换语义入参失败:{}",e.getMessage());
        }
        return res;
    }
}
