package com.digiwin.athena.adt.agileReport.controller.log;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataFeedBackDTO;
import com.digiwin.athena.adt.agileReport.service.AgileReportFeedBackService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping(value = "/api/ai/agileDataFeedback")
public class AgileReportFeedbackController {

    @Autowired
    private AgileReportFeedBackService agileReportFeedBackService;

    /**
     * 记录点赞/点踩行为
     * @param user
     * @param agileDataFeedBackDTO
     * @return
     */
    @PostMapping("/user/feedback")
    public ResponseEntity<?> userFeedback(HttpServletRequest request,@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                          @RequestBody AgileDataFeedBackDTO agileDataFeedBackDTO) {
        String clientAgent = request.getHeader("client-agent");
        return ResponseEntityWrapper.wrapperOk(agileReportFeedBackService.saveFeedback(user,agileDataFeedBackDTO,clientAgent));
    }

    /**
     * 取消点赞/点踩行为
     * @param user
     * @param agileDataFeedBackDTO
     * @return
     */
    @PostMapping("/user/cancel")
    public ResponseEntity<?> cancelFeedback(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                            @RequestBody AgileDataFeedBackDTO agileDataFeedBackDTO) {
        agileReportFeedBackService.deleteFeedback(user,agileDataFeedBackDTO);
        return ResponseEntityWrapper.wrapperOk(true);
    }

    /**
     * 接收用户反馈意见
     * @param user
     * @param agileDataFeedBackDTO
     * @return
     */
    @PostMapping("/user/answerBack")
    public ResponseEntity<?> answerBack(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                        @RequestBody AgileDataFeedBackDTO agileDataFeedBackDTO) {
        agileReportFeedBackService.answerBack(user,agileDataFeedBackDTO);
        return ResponseEntityWrapper.wrapperOk(true);
    }

    /**
     * 获取用户反馈意见
     * @param user
     * @param generateSerialNoList
     * @return
     */
    @PostMapping("/user/getFeedback")
    public ResponseEntity<?> getFeedback(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                         @RequestBody List<Long> generateSerialNoList) {
        return ResponseEntityWrapper.wrapperOk(agileReportFeedBackService.getFeedback(user,generateSerialNoList));
    }

}
