package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageReqDTO;
import com.digiwin.athena.adt.agileReport.service.AgileApcDataService;
import com.digiwin.athena.adt.domain.dto.apc.AgileApcDataEocMap;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/8/13 19:10
 * @Description: apc大屏请求链路
 */
@RestController
@RequestMapping(value = "/api/ai/agile/apc")
public class AgileApcDataController {

    @Autowired
    private AgileApcDataService agileApcDataService;

    /**
     * apc 请求入口
     * @param req request param
     * @return apc res
     */
    @PostMapping("/processMessage")
    public ResponseEntity<?> processMessage(HttpServletRequest request, @RequestBody AthenaApcMessageReqDTO req,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        String locale = request.getHeader("locale");
        Objects.requireNonNull(req, "传入的AthenaApcMessageReqDTO为空！");
        if(CollectionUtils.isEmpty(req.getEocMaps())){
            AgileApcDataEocMap agileApcDataEocMap = new AgileApcDataEocMap();
            agileApcDataEocMap.setEocSiteId(MapUtils.getString(req.getEocMap(), "eocSiteId"));
            agileApcDataEocMap.setEocCompanyId(MapUtils.getString(req.getEocMap(), "eocCompanyId"));
            req.setEocMaps(Lists.newArrayList(agileApcDataEocMap));
        }
        if(StringUtils.isEmpty(req.getRequestType())){
            req.setRequestType("sync-snapshot");
        }
        return ResponseEntityWrapper.wrapperOk(agileApcDataService.processMessage(request,req,user,locale));
    }


}
