package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTReq;
import com.digiwin.athena.adt.agileReport.service.AIBoardService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@RestController
@RequestMapping(value = "/api/ai/agileData/aiBoard")
public class AgileDataAIBoardController {

    @Autowired
    private AIBoardService aiBoardService;

    @PostMapping("/generateAIBoard")
    public ResponseEntity<?> generateAIBoard(HttpServletRequest request, @RequestBody AgileDataPPTReq agileDataPPTReq,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(agileDataPPTReq, "传入的生成看板数据为空！");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(aiBoardService.generateAIBoard(user, agileDataPPTReq.getMessageId(), locale));
    }

}
