package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataAutoDataReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AutoDataDownLoadReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AutoDataGenerateReportReq;
import com.digiwin.athena.adt.agileReport.service.AgileDataAutoDataService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@RestController
@RequestMapping(value = "/api/ai/agileData/autoData")
public class AgileDataAutoDataController {

    @Autowired
    private AgileDataAutoDataService agileDataAutoDataService;

    /**
     * 获取实时数据
     * @param request
     * @param req
     * @param user
     * @return
     */
    @PostMapping("/getData")
    public ResponseEntity<?> processMessage(HttpServletRequest request, @RequestBody AgileDataAutoDataReq req,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        Objects.requireNonNull(req, "获取实时总结数据为空！");
        return ResponseEntityWrapper.wrapperOk(agileDataAutoDataService.getData(request,user,req));
    }

    /**
     * 生成分析报告
     * @param request
     * @param req
     * @param user
     * @return
     */
    @PostMapping("/generateReport")
    public ResponseEntity<?> generateReport(HttpServletRequest request, @RequestBody AutoDataGenerateReportReq req,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        Objects.requireNonNull(req, "获取生成分析报告为空！");
        return ResponseEntityWrapper.wrapperOk(agileDataAutoDataService.getReportData(request,user,req));
    }

    /**
     * 生成分析报告
     * @param request
     * @param req
     * @param user
     * @return
     */
    @PostMapping("/getDownLoadUrl")
    public ResponseEntity<?> getDownLoadUrl(HttpServletRequest request, @RequestBody AutoDataDownLoadReq req,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        Objects.requireNonNull(req, "下载分析师报告！");
        return ResponseEntityWrapper.wrapperOk(agileDataAutoDataService.getDownLoadInfo(request,user,req));
    }

}
