package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateConfigService;
import com.digiwin.athena.adt.domain.po.AgileDataCalculateConfig;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 10:31
 * @Description: 计费提示配置
 */
@RestController
@RequestMapping(value = "/api/ai/agile")
public class AgileDataCalculateConfigController {

    @Autowired
    private AgileDataCalculateConfigService agileDataCalculateConfigService;

    @PostMapping("/calculate/config/insert")
    public ResponseEntity<?> insert(@RequestBody AgileDataCalculateConfig agileDataCalculateConfig,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataCalculateConfigService.insert(agileDataCalculateConfig,user));
    }

    @PostMapping("/calculate/config/update")
    public ResponseEntity<?> update(@RequestBody AgileDataCalculateConfig agileDataCalculateConfig,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataCalculateConfigService.update(agileDataCalculateConfig,user));
    }

    @PostMapping("/calculate/config/delete")
    public ResponseEntity<?> delete(@RequestBody AgileDataCalculateConfig agileDataCalculateConfig,
                                                @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        return ResponseEntityWrapper.wrapperOk(agileDataCalculateConfigService.delete(agileDataCalculateConfig,user));
    }

    /**
     * 根据用户信息查询是否需要提示计费阈值告警
     * @param user 用户信息
     * @return true/false
     */
    @PostMapping("/calculate/config/query")
    public ResponseEntity<?> queryCalculateConfigByUser(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataCalculateConfigService.queryCalculateConfigByUser(user));
    }

    /**
     * 根据用户查询adt 配置流量 id 查询cac 详情
     * @param user 用户信息
     * @return cac 详情
     */
    @PostMapping("/calculate/config/queryCacByConfig")
    public ResponseEntity<?> queryCalculateCacByConfig(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataCalculateConfigService.queryCalculateCacByConfig(user));
    }

    /**
     * 根据用户信息查询是否开启计费
     * @param user 用户细腻些
     * @return true/false
     */
    @PostMapping("/calculate/getIsBilling")
    public ResponseEntity<?> getIsBilling(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataCalculateConfigService.getIsBilling(user));
    }
}
