package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.service.AgileDataClassificationsService;
import com.digiwin.athena.adt.domain.po.AgileDataClassifications;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 10:31
 * @Description: 计费提示配置
 */
@RestController
@RequestMapping(value = "/api/ai/agile")
public class AgileDataClassificationsController {

    @Autowired
    private AgileDataClassificationsService agileDataClassificationsService;

    @PostMapping("/classifications/insert")
    public ResponseEntity<?> insert(@RequestBody AgileDataClassifications agileDataClassifications,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        agileDataClassificationsService.insert(agileDataClassifications,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/classifications/update")
    public ResponseEntity<?> update(@RequestBody AgileDataClassifications agileDataClassifications,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        agileDataClassificationsService.update(agileDataClassifications,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/classifications/delete")
    public ResponseEntity<?> delete(@RequestBody AgileDataClassifications agileDataClassifications,
                                                @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        agileDataClassificationsService.delete(agileDataClassifications,user);
        return ResponseEntityWrapper.wrapperOk();
    }
}
