package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AniaAssistantChatReqDTO;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@RestController
@RequestMapping(value = "/api/ai/agileData/filter")
public class AgileDataFilterDataController {

    @Autowired
    private SnapShotDataService snapShotDataService;

    @PostMapping("/agileData")
    public ResponseEntity<?> filterAgileData(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO agileFilterDataDTO,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(agileFilterDataDTO, "传入的筛选数据为空！");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.filterAgileData(request,agileFilterDataDTO, user, locale));
    }

}
