package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTReq;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateReq;
import com.digiwin.athena.adt.agileReport.service.AgileDataPPTService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * ppt生成
 */
@RestController
@RequestMapping(value = "/api/ai/agileData/anasisly")
public class AgileDataPPTController {

    @Autowired
    private AgileDataPPTService agileDataPPTService;

    @PostMapping("/getAnasislyQuestion")
    public ResponseEntity<?> getAnasislyQuestion(HttpServletRequest request, @RequestBody AgileDataPPTReq agileDataPPTReq,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(agileDataPPTReq, "传入的重新规划数据为空！");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(agileDataPPTService.getPPTAnalyze(user, agileDataPPTReq, locale));
    }


    @PostMapping("/generateAgileDataFile")
    public ResponseEntity<?> generateAgileDataFile(HttpServletRequest request, @RequestBody AgileDataGenerateReq agileDataGenerateReq,
                                                   @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(agileDataGenerateReq, "传入的生成ppt数据为空！");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(agileDataPPTService.generatePPT(user,agileDataGenerateReq, locale));
    }

}
