package com.digiwin.athena.adt.agileReport.event;

import com.digiwin.athena.adt.agileReport.constant.event.EventMqConstants;
import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.event.service.impl.SubscribeEventImpl;
import com.digiwin.athena.adt.agileReport.service.EventBaseService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: xusj
 * @date: 2023/8/22 13:36
 */
@Slf4j
@Controller
@RequestMapping(value = "/api/test/ptm")
public class EventMqTestController {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private EventBaseService eventBaseService;

    @Autowired
    private SubscribeEventImpl subscribeEvent;

    /**
     * 模拟 PTM 消息推送
     * @param data
     * @param user
     * @return
     */
    @PostMapping(value = "/mq/send", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> mockMqSend(@RequestBody String data,
                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        rabbitTemplate.convertAndSend(EventMqConstants.EVENT_MQ_EXCHANGE_NAME, EventMqConstants.EVENT_MQ_ROUTING_SUBSCRIBE, data);
        return ResponseEntity.ok(data);
    }

    @PostMapping(value = "/mq/message", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> mockMqMessage(@RequestBody String data,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        try {
            eventBaseService.receiveOrder(data,null,null,0L,null);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return ResponseEntity.ok(data);
    }

    @PostMapping(value = "/mq/send/subscribe", produces = "application/json;charset=UTF-8")
    public ResponseEntity<?> subscribe(@RequestBody String data,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        EventSubscribeDTO subscribeDTO = new EventSubscribeDTO();
        subscribeDTO.setMsgType("agileSubscribe");
        Map<String,Object> msgBody = new HashMap<>();
        msgBody.put("text","今年的营收金额");
        Map<String,Object> msgExt = new HashMap<>();
        msgExt.put("question","今年的营收金额");
        msgExt.put("sceneCode","S202405130010");
        msgExt.put("multiDialogue",false);
        msgExt.put("userName","林川");
        msgExt.put("type","agileSubscribe");
        msgExt.put("userId","wangchaom@digiwin.com");
        msgExt.put("tenantId","AthenaHZTest");
        subscribeDTO.setMsgBody(msgBody);
        subscribeDTO.setMsgExt(msgExt);
        Map<String,Object> headers = new HashMap<>();
        headers.put("token","e9f750bc-ffef-42e8-a616-1fe8c6bd1d7b");
        subscribeEvent.processMessage(subscribeDTO,headers);
        return ResponseEntity.ok(data);
    }
}
