package com.digiwin.athena.adt.agileReport.event.domain;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 17:11
 * @Description:
 */
@Data
public class SendMessageReqDTO implements Serializable {

    /**
     * 消息主体
     */
    private SendMessageDTO sendMessageDTO;

    /**
     * user token
     */
    private String token;

    /**
     * 用户问句
     */
    private String question;

    /**
     * 语义组合问句
     */
    private String combinationQuestion;

    /**
     * 语义例句
     */
    private List<String> sentences;

    /**
     * 本次问答，唯一标识
     */
    private Long generateSerialNo;

    /**
     * 是否可以获取到问题答案（1.成功2.失败）
     */
    private Integer answerResult;

    /**
     * 消息类型 0.单场景消息1.多场景消息2.debug消息3.引用消息
     */
    private String messageType;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 语义新增上下文字段
     * questionUnderstand
     */
    private String questionUnderstand;

    private boolean getMessageInfo;


    /**
     * 构建发送消息和是否发送查询echo
     * @param event 上下文
     * @param messageBody 其他信息
     * @return 发送娜娜固定入参
     */
    public static SendMessageReqDTO builderMessageAndType(AthenaMessageEvent event,
                                                          Map<String, Object> messageBody) {
        SendMessageReqDTO sendMessageReqDTO = new SendMessageReqDTO();
        SendMessageDTO sendMessageDTO = new SendMessageDTO();
        sendMessageDTO.setMsgBody(messageBody);
        sendMessageDTO.setMsgExt(event.getMsgExt());
        sendMessageDTO.setMethod(event.getMethod());
        sendMessageDTO.setGetMessageInfo(event.isGetMessageInfo());
        // 语义导正选择时 去除metric对象中的其他值
        if (CollectionUtils.isNotEmpty(event.getMetricList())) {
            List<Map<String, Object>> filteredList = event.getMetricList().stream()
                    .map(SendMessageReqDTO::extractMetricIdAndName)
                    .collect(Collectors.toList());
            sendMessageDTO.setMetricList(filteredList);
        } else {
            sendMessageDTO.setMetricList(event.getMetricList());
        }
        sendMessageDTO.setAsaCode(event.getAsaCode());
        if (event.isDebug() && AgileDataEnum.METRIC.getCode().equals(event.getMethod())) {
            sendMessageDTO.setDebugModel(AgileDataEnum.METRIC.getCode());
        }
        sendMessageDTO.setMessageId(event.getGenerateSerialNo());
        sendMessageDTO.setUserId(event.getUser().getUserId());
        sendMessageReqDTO.setSendMessageDTO(sendMessageDTO);
        sendMessageReqDTO.setToken(event.getUser().getToken());
        sendMessageReqDTO.setTenantId(event.getUser().getTenantId());
        sendMessageReqDTO.setQuestion(event.getQuestion());
        sendMessageReqDTO.setCombinationQuestion(event.getCombinationQuestion());
        sendMessageReqDTO.setQuestionUnderstand(event.getQuestionUnderstand());
        sendMessageReqDTO.setGenerateSerialNo(event.getGenerateSerialNo());
        sendMessageReqDTO.setSentences(event.getSentences());
        sendMessageReqDTO.setAnswerResult(event.getAnswerResult());
        sendMessageReqDTO.setMessageType(event.getMessageType());
        sendMessageReqDTO.setGetMessageInfo(event.isGetMessageInfo());
        return sendMessageReqDTO;
    }



    /**
     * metricList
     * @param map metricList
     * @return extract List
     */
    public static Map<String, Object> extractMetricIdAndName(Map<String, Object> map) {
        Map<String, Object> newMap = new HashMap<>();
        newMap.put("metricId", map.get("metricId"));
        newMap.put("metricName", map.get("metricName"));
        return newMap;
    }
}
