package com.digiwin.athena.adt.agileReport.event.service.impl;


import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.event.EventMqConstants;
import com.digiwin.athena.adt.agileReport.event.domain.EventReportDataDTO;
import com.digiwin.athena.adt.agileReport.event.service.EventInterface;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.aim.AimBuildReqDTO;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.message.AgileDataMessageUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.domain.message.MessageBatchUserDTO;
import com.digiwin.athena.atmc.http.restful.aim.AimService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 敏捷报表解析
 */
@Service
@Slf4j
public class ReportEventImpl implements EventInterface {

    @Autowired
    private SnapShotDataService snapShotDataService;

    @Autowired
    private AimService aimService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private UserService userService;

    @Autowired
    private DmcService dmcService;

    @Override
    public String modelType() {
        return EventMqConstants.EVENT_MQ_QUEUE_NAME;
    }


    @Override
    public void distributeMessages(String data, Map<String,Object> headers) {
        EventReportDataDTO eventReportDataDTO = JsonUtils.jsonToObject(data,EventReportDataDTO.class);
        if(eventReportDataDTO != null){
            this.executeReport(eventReportDataDTO);
        }
    }

    /**
     * 数据处理
     * @param mqData
     */
    public void executeReport(EventReportDataDTO mqData){
        log.info("executeReport EventReportDataDTO req : {}", JsonUtils.objectToString(mqData));
        //查询敏捷报表信息
        List<SnapData> snapDataList = snapShotDataService.getSnapShotUserList(mqData.getSnapshotId());
        LogDto dataLogDto = new LogDto("查询快照数据：" + snapDataList);
        log.info(dataLogDto.toString());
        if(CollectionUtils.isEmpty(snapDataList)){
            return;
        }
        for(SnapData snapData : snapDataList) {
            //下发MQTT消息
            AuthoredUser authoredUser = new AuthoredUser();
            authoredUser.setUserName(snapData.getUserName());
            authoredUser.setUserId(snapData.getPerformerId());
            authoredUser.setTenantId(snapData.getTenantId());
            authoredUser.setToken(mqData.getToken());

            SnapShotDTO snapShotDTO = dmcService.getAgileDataByToken(snapData.getDmcId(),mqData.getToken());
            if(null == snapShotDTO || StringUtils.isEmpty(snapShotDTO.getContext().getBizParams().getQuestion())) {
                return;
            }
            if(snapData.getEntry() == 0){
                // v 1.0 aim
                aimService.message(authoredUser, AgileDataMessageUtils.buildDetectionMessage(snapData,authoredUser));
            }else if(snapData.getEntry() == 2){
                // 获取aim需要信息
                AimBuildReqDTO aimBuildReqDTO = AimBuildReqDTO.builderAimReqDTO(authoredUser,snapData,
                        userService, messageUtil);
                // 问句
                String chartTitle = MapUtils.getString(snapShotDTO.getContext().getBizParams().getParam(),"chartTitle");
                if(StringUtils.isNotEmpty(chartTitle)){
                    aimBuildReqDTO.setChartTitle(chartTitle);
                }
                aimBuildReqDTO.setQuestion(snapShotDTO.getContext().getBizParams().getQuestion());
                String method = snapShotDTO.getContext().getBizParams().getMethod();
                if(CollectionUtils.isNotEmpty(snapShotDTO.getContext().getPullData())){
                    List<Map<String,Object>> metricList = snapShotDTO.getContext().getPullData().get(0).getMetricList();
                    aimBuildReqDTO.setMetricList(metricList);
                    List<Map<String,Object>> datasetList = snapShotDTO.getContext().getPullData().get(0).getDatasetList();
                    aimBuildReqDTO.setDatasetList(datasetList);
                }
                Object undeleteTable = snapShotDTO.getContext().getBizParams().getParam().get("undeletable");
                Object isProcessStr = snapShotDTO.getContext().getBizParams().getDataProcessAction();
                String asaCode = MapUtils.getString(snapShotDTO.getContext().getBizParams().getParam(),"asaCode");
                String ruleId = MapUtils.getString(snapShotDTO.getContext().getBizParams().getParam(),"ruleId");
                List<Map<String,Object>> stepAnalysis = snapShotDTO.getContext().getStepAnalysis();
                List<Map<String,Object>> stepFilterAnalysis = snapShotDTO.getContext().getStepFilterAnalysis();
                aimBuildReqDTO.setRuleId(ruleId);
                aimBuildReqDTO.setAsaCode(asaCode);
                aimBuildReqDTO.setStepAnalysis(stepAnalysis);
                aimBuildReqDTO.setStepFilterAnalysis(stepFilterAnalysis);
                Integer interceptionSize = snapShotDTO.getContext().getBizParams().getInterceptSize();
                if(Objects.nonNull(isProcessStr) && "interception".equals(isProcessStr)){
                    String dataTipMessage = messageUtil.getMessageByLangNameWithFormat(
                            "message.adt.message.page",aimBuildReqDTO.getUserLang(),interceptionSize);
                    aimBuildReqDTO.setDataTipMessage(dataTipMessage);
                }
                // 语义业务类型 dataflow/method
                aimBuildReqDTO.setMethod(StringUtils.isEmpty(method)? SchemaConstants.METHOD_DATA_FLOW : method);
                aimBuildReqDTO.setUndeletable(!Objects.isNull(undeleteTable) && (boolean) undeleteTable);
                // v2.0 aim request
                List<MessageBatchUserDTO> message = AgileDataMessageUtils.buildAgileSubscribeMessage(aimBuildReqDTO);
                log.info("aimService.saveNewMessage req : {}", JsonUtils.objectToString(message));
                aimService.saveNewMessage(authoredUser, message);
            }else{
                // aimService.sendMessageToClient(authoredUser.getToken(),authoredUser.getTenantId(),Lists.newArrayList(authoredUser.getUserId()),messageDO);
                return;
            }

        }
    }

    @Override
    public void consumeMessage(String data, Channel channel, long tag) throws IOException {

    }

}
