package com.digiwin.athena.adt.agileReport.event.service.impl;

import com.digiwin.athena.adt.agileReport.constant.AgileDataSourceEnum;
import com.digiwin.athena.adt.agileReport.constant.event.EventMqConstants;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.event.service.EventInterface;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.domain.report.impl.AbsAgileEventProcess;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.ExecutorService;

/**
 * @Author: SunHong
 * @Date: 2024/6/25 14:01
 * @Description: 订阅消息 RabbitMQ 实现
 */
@Service
@Slf4j
public class SubscribeEventImpl extends AbsAgileEventProcess implements EventInterface {

    @Autowired
    @Qualifier("asyncServiceExecutor")
    private ExecutorService executor;

    @Autowired
    private AgileDataMessageService agileDataMessageService;

    @Override
    public String modelType() {
        return EventMqConstants.EVENT_MQ_QUEUE_SUBSCRIBE;
    }

    @Override
    public void distributeMessages(String data,Map<String,Object> headers) {
        log.info("[athena.event.message.adt-distributeMessages]: data {}", JsonUtils.objectToString(data));
        EventSubscribeDTO subscribeDTO = JsonUtils.jsonToObject(data,EventSubscribeDTO.class);
        if(subscribeDTO != null){
            this.processMessage(subscribeDTO,headers);
        }

    }

    public void processMessage(EventSubscribeDTO subscribeDTO,Map<String,Object> headers) {
        LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "receiveQuestion", LogUtils.SUCCESS,
                JsonUtils.objectToString(subscribeDTO), "订阅消息请求", "");
        String token = String.valueOf(headers.get("token"));
        // 1.0 订阅用户信息
        AuthoredUser adtUser = new AuthoredUser();
        adtUser.setToken(token);
        adtUser.setUserId(String.valueOf(subscribeDTO.getMsgExt().get("userId")));
        adtUser.setUserName(String.valueOf(subscribeDTO.getMsgExt().get("userName")));
        adtUser.setTenantId(String.valueOf(subscribeDTO.getMsgExt().get("tenantId")));
        adtUser.setTenantName(String.valueOf(subscribeDTO.getMsgExt().get("tenantName")));
        AthenaMessageDTO athenaMessageDTO = new AthenaMessageDTO();
        BeanUtils.copyProperties(subscribeDTO, athenaMessageDTO);
        athenaMessageDTO.setAppCode(String.valueOf(subscribeDTO.getTo().get("appCode")));
        athenaMessageDTO.setAsaCode(String.valueOf(subscribeDTO.getMsgExt().get("asaCode")));
        // 初始化event
        AthenaMessageEvent event = init(null,athenaMessageDTO,adtUser);
        event.setSubscribe(true);
        event.setSendNana(false);
        event.setSourceName(AgileDataSourceEnum.SUBSCRIBER.getName());
        event.setSourceCode(AgileDataSourceEnum.SUBSCRIBER.getCode());
        event.setAppCode(String.valueOf(subscribeDTO.getTo().get("appCode")));
        Object snapshotId = subscribeDTO.getMsgExt().get("snapshotId");
        executor.submit(() -> {
            if(Objects.isNull(snapshotId)){
                agileDataMessageService.process(event);
            }else{
                agileDataMessageService.processSubscribeV2(event,subscribeDTO);
            }
        });
    }

    @Override
    public void consumeMessage(String data, Channel channel, long tag) throws IOException {

    }
}
