package com.digiwin.athena.adt.agileReport.eventbus;

import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * 收集日志事件
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class AgileDataLogEvent {

    /**
     * 用户信息
     */
    private AuthoredUser authoredUser;

    /**
     * 端
     */
    private String terminal;

    /**
     * 消息ID
     */
    private Long generateSerialNo;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 问句
     */
    private String question;

    /**
     * 异常信息
     */
    private String  errorAnswer;

    /**
     * 用户反馈项
     */
    private String backContent;


    /**
     * 反馈信息
     */
    private String checkOpinions;


    /**
     * 用户意见
     */
    private String answerOpinion;


    /**
     * 点赞/点踩 0.点赞 1.点踩
     */
    private Integer feedbackType;

    /**
     * 答题是否成功
     * (0 异常/1 正常)
     */
    private Integer success;

    /**
     * 来源名称
     */
    private String sourceName;

    /**
     * 来源编码
     */
    private String sourceCode;

    /**
     * 应用Id
     */
    private String applicationCode;

    /**
     * 应用名称
     */
    private String applicationName;


    /**
     * 是否被分析
     */
    private String logSaveSuccess;

    /**
     * 错误原因
     */
    private String reason;

    private String productVersion;

    //================================以下信息非必有==========================

    /**
     * 查询参数
     */
    private Map<String,Object> params;

    /**
     * 问题结果业务数据
     */
    private Map<String,Object> data;

    /**
     * 客户端扩展信息
     */
    private Map<String,Object> extendInfo;

    /**
     * 查询sql语句
     */
    private Map<String,Object> querySchema;

    /**
     * 操作记录 0.数据日志记录 1.异常日志记录 2.用户点赞/点踩 3.用户反馈 4.用户取消点赞/点踩
     */
    private Integer type;

    /**
     * 多语言标识
     */
    private String local;

    /**
     * 判断是否获取敏捷数据
     */
    private boolean isMessageGet;

    /**
     * 提问时间
     */
    private LocalDateTime askTime;

    /**
     * 回答记录时间
     */
    private LocalDateTime answerTime;

    /**
     * ade 入参
     */
    private ADEScencDTO adeScencDTO;

    /**
     * 链路id
     */
    private String ptxId;

}
