package com.digiwin.athena.adt.agileReport.eventbus.subscriber;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
@Slf4j
public class AthenaMessageSendEventSubscriber {

    @Autowired
    private AgileDataMessageService agileDataMessageService;

    /**
     * @param event
     */
    @Subscribe
    @AllowConcurrentEvents
    public void subscriber(AthenaMessageEvent event){
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        }catch (Exception ex){
            log.error("消息推送结束 error:{}, stack:{}，event:{}" ,ex, ex.getStackTrace(), event);
        }finally {
            AppAuthContextHolder.clearContext();
        }
    }

    /**
     * 异步队列处理，调用chartBI接口
     * @param event
     */
    public void processEvent(AthenaMessageEvent event){
        log.info("AthenaMessageSendEventSubscriber processEvent ：{} ", JsonUtils.objectToString(event));
         agileDataMessageService.process(event);
    }

}
