package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.controller.dto.*;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import javax.servlet.http.HttpServletRequest;

public interface AgileDataAutoDataService {

    /**
     * 获取分析师数据
     * @param authoredUser
     * @return
     */
    AgileDataAutoDataRes getData(HttpServletRequest request,AuthoredUser authoredUser, AgileDataAutoDataReq autoDataReq);

    /**
     * 获取已生成分析师报告
     * @param request
     * @param authoredUser
     * @param autoDataReq
     * @return
     */
    AgileDataAutoDataDTO getReportData(HttpServletRequest request, AuthoredUser authoredUser, AutoDataGenerateReportReq autoDataReq);

    /**
     * 下载分析师报告
     * @param request
     * @param authoredUser
     * @param req
     * @return
     */
    AutoDataDownLoadDTO getDownLoadInfo(HttpServletRequest request, AuthoredUser authoredUser, AutoDataDownLoadReq req);

}
