package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.CalculateCostResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/24 15:31
 * @Description: 计费
 */
public interface AgileDataCalculateCostService {

    /**
     * 正常问句
     * 1.根据语义以及用户信息判断本次是否计费
     * 2.需要计费,判断是否执行
     * 3.存在无需计费,需要计费流量不够,并且发送或不发送娜娜,记录日志
     * @param event 上下文
     * @param querySchemaResDTO 语义返回
     * @return 是否通过、
     */
    boolean calculateCostByCode(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO);

    /**
     * 扣减流量和阈值判断
     * 1.扣减流量 2.是否成功 3 扣减剩余次数是否小于阈值告警 4 发送echo
     * @param event 上下文
     * @return 是否通过
     */
    boolean designerDecreaseCurrentTenant(AthenaMessageEvent event);

    /**
     * 数据看板
     * 校验计费
     * @param event 上下文
     * @return 是否通过
     */
    AgileDataProcessResDTO calculateCostResult(AthenaMessageEvent event,
                                               QuerySchemaResDTO querySchemaResDTO,
                                               AgileDataProcessResDTO agileDataProcessResDTO);

    /**
     * 根据上下文二次校验
     * 校验计费
     * @param event 上下文
     * @return 是否通过
     */
    boolean secondCalculateCostByCode(AthenaMessageEvent event);

    /**
     * 计费组合实现
     * 1.二次校验
     * 2.扣减计费
     * 3.记录日志和娜娜
     * @param event 上下文
     * @param data ade 返参
     * @param sendMap 发送消息体
     * @return 是否通过 为true时 是无需计费流程,以及计费扣减成功流程
     */
    boolean combinedBillingCalculation(AthenaMessageEvent event, Map<String,Object> data, Map<String,Object> sendMap);

    /**
     * 数据看板计费组合实现
     * 1.二次校验
     * 2.扣减计费
     * 3.记录日志和娜娜
     * @param event 上下文
     * @return 是否通过 为true时 是无需计费流程,以及计费扣减成功流程
     */
    AgileDataProcessResDTO combinedBillingCalculationPanel(AthenaMessageEvent event, SnapShotDTO snapShotDTO);


    /**
     * 计费 流控校验 - 根据用户 、流量id 、应用编码,抽象实现 非业务耦合
     * @param user u
     * @param appCode  a
     * @param billingGoodsId b
     * @return true/false
     */
    CalculateCostResDTO calculateCostByUser(AuthoredUser user, String appCode, String billingGoodsId);

}
