package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectStepResDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

public interface AgileDataMessageService {

    /**
     * 消息处理
     * @param event
     */
    void process(AthenaMessageEvent event);

    /**
     * 消息处理 返回参数
     * @param event 消息体
     */
    AgileDataProcessResDTO processRes(AthenaMessageEvent event);

    void sseProcess(AthenaMessageEvent event,  SSEBaseEvent sseBaseEvent);


    AgileDataProcessResDTO processResV1(AthenaMessageEvent event,SnapShotDTO snapshotInfo, KMCollectStepResDTO stepResDTO);

    AgileDataProcessResDTO processResV2(AthenaMessageEvent event, SnapShotDTO snapshotInfo, ThemeMapBoardDTO themeMapBoardDTO, AdeDatasetReqDTO adeDatasetReqDTO);

    /**
     * 2.0 订阅直接取数
     * @param event e
     * @param subscribeDTO s
     */
    void processSubscribeV2(AthenaMessageEvent event, EventSubscribeDTO subscribeDTO);

    void processPPT(AthenaMessageEvent event);

    void processAIBoard(AthenaMessageEvent event);

    void processPPTAfter(AuthoredUser user,Long pptMessageId);

    void processAIBoardAfter(AuthoredUser user,Long aiBoardMessageId);

    void processAutoData(AthenaMessageEvent event, String url, Map<String, Object> req, SSEBaseEvent sseBaseEvent);
}
