package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTRes;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateReq;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateRes;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

/**
 * ppt生成服务
 */
public interface AgileDataPPTService {

    /**
     * 重新生成分析规划
     * @param user
     * @param agileDataPPTReq
     * @return
     */
    AgileDataPPTRes getPPTAnalyze(AuthoredUser user, AgileDataPPTReq agileDataPPTReq, String locale);

    /**
     * 生成PPT
     * @param user
     * @param agileDataGenerateReq
     * @param locale
     * @return
     */
    AgileDataGenerateRes generatePPT(AuthoredUser user, AgileDataGenerateReq agileDataGenerateReq, String locale);

}
