package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataFeedBackDTO;
import com.digiwin.athena.adt.domain.dto.AgileDataFeedBack;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;

/**
 * 用户反馈
 */
public interface AgileReportFeedBackService {

    /**
     *  保存点赞/点踩记录
     * @param agileDataFeedBackDTO
     */
    Boolean saveFeedback(AuthoredUser authoredUser,AgileDataFeedBackDTO agileDataFeedBackDTO,String clientAgent);

    /**
     * 删除点赞/点踩记录
     * @param agileDataFeedBackDTO
     */
    void deleteFeedback(AuthoredUser authoredUser,AgileDataFeedBackDTO agileDataFeedBackDTO);

    /**
     * 保存用户体验
     * @param agileDataFeedBackDTO
     */
    void answerBack(AuthoredUser authoredUser,AgileDataFeedBackDTO agileDataFeedBackDTO);

    /**
     * 获取用户点赞/点踩记录
     * @param generateSerialNoList
     * @return
     */
    List<AgileDataFeedBack> getFeedback(AuthoredUser authoredUser, List<Long> generateSerialNoList);

}
