package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileReportDetailParamsDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.ReportIntentionRequestDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

/**
 * 敏捷报表数据交互
 */
public interface AgileReportService {



     /**
      * 获取敏捷报表明细数据
      * @param agileReportDetailParamsDTO
      * @return
      */
     List<Map<String, Object>> getReportDetailData(AgileReportDetailParamsDTO agileReportDetailParamsDTO);

     /**
      * 根据用户意图，获取报表明细数据
      * @param reportIntentionRequestDTO
      * @return
      */
     List<Map<String,Object>> getIntentionData(ReportIntentionRequestDTO reportIntentionRequestDTO);

     /**
      * 处理业务数据转换
      * @param user
      * @param event
      * @param adeResult
      */
     void executeAgileDataByTokenSize(AuthoredUser user,AthenaMessageEvent event, Map<String,Object> adeResult);

}
