package com.digiwin.athena.adt.agileReport.service;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 13:21
 * @Description:
 */
public interface SchemaDataProcessService {

    /**
     * 执行ade 分层
     */
    Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event);

    /**
     * 根据入参业务类型返回sse入参
     * @param event 上下文
     * @return 入参
     */
    Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event);

    /**
     * sse 语义返回后续逻辑实现
     * @param event 上下文
     * @param jsonObject 语义返回对象
     * @return 是否成功
     */
    Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject);
}
