package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.domain.dto.agileReport.*;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmUserResponseDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;


@Slf4j
@Service
public class SnapShotCommonService {

    @Autowired
    private AgileReportDataService agileReportDataService;

    @Autowired
    private SnapShotDataService snapShotDataService;

    /**
     * 将snapdata上传文档中心和存入数据库
     * @param snapShotDTO
     * @return
     */
    public void processAndSaveSnapShotData(String snapDataJsonString, SnapShotDTO snapShotDTO, AuthoredUser user) {
        String uploadFileId = "";
        try{
            if(snapShotDTO != null) {
                String monitorRuleId = Optional.ofNullable(snapShotDTO).map(SnapShotDTO::getContext)
                        .map(ContextDTO::getBizParams).map(BizParamsDTO::getMonitor).map(MonitorDTO::getMonitorRuleId)
                        .orElse(null);
                List<TmUserResponseDto> userResponses = Lists.newArrayList();
                if (StringUtils.isNotEmpty(monitorRuleId)) {
                    userResponses = snapShotDataService.getUserResponse(snapShotDTO);
                } else {
                    TmUserResponseDto tmUserResponseDto = new TmUserResponseDto();
                    tmUserResponseDto.setUserId(snapShotDTO.getContext().getBizParams().getRequestPerson());
                    tmUserResponseDto.setUserName(snapShotDTO.getContext().getBizParams().getRequestPersonName());
                    userResponses.add(tmUserResponseDto);
                }
                if (userResponses == null || userResponses.isEmpty()) {
                    throw ErrorCodeEnum.USERINFO_IS_EMPTY.getBusinessException();
                }
                log.info("快照服务消息{},message:{}", snapShotDTO.getSnapshotId(), snapDataJsonString);
                uploadFileId = agileReportDataService.processSDData(JsonUtils.objectToString(snapShotDTO), snapShotDTO.getSnapshotId(), user);
                snapShotDataService.saveSnapShotData(snapShotDTO, uploadFileId, userResponses);
                LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "snapshotSave", LogUtils.SUCCESS,
                        snapDataJsonString, uploadFileId, "");
            }
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "snapshotSave", TroubleToolCodeEnum.ADT_901_0127.getErrCode(),
                    JsonUtils.objectToString(snapDataJsonString), TroubleToolCodeEnum.ADT_901_0127.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0127.getSuggestion());
        }

    }
}
