package com.digiwin.athena.adt.agileReport.service;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataMoreActionDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileReportDetailParamsDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileTransDataDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AniaAssistantChatReqDTO;
import com.digiwin.athena.adt.domain.dto.AgileDatFilterDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.AamDataResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PageReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.SDScencDTO;
import com.digiwin.athena.adt.domain.dto.SnapDataInfoDTO;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmUserResponseDto;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

public interface SnapShotDataService {

    /**
     * 存储快照信息
     * @param snapShotDTO
     */
    void saveSnapShotData(SnapShotDTO snapShotDTO, String uploadFileId, List<TmUserResponseDto> userResponses);

    /**
     * 获取人员信息
     * @param snapShotDTO
     */
    List<TmUserResponseDto> getUserResponse(SnapShotDTO snapShotDTO);

    /**
     * 从agile_data表中，按tenantId和userId获取快照信息
     *
     * @param tenantId
     * @param userId
     * @return
     */
    List<SnapData> getSnapShotDataList(String tenantId, String userId, PageReqDTO pageReqDTO);

    /**
     * 获取敏捷报表信息
     * @param tenantId
     * @param userId
     * @param snapshotId
     * @return
     */
    SnapData getSnapDataBySnapshotId(String tenantId,String userId,String snapshotId);

    /**
     * 敏捷快照信息
     * @param tenantId
     * @param userId
     * @param snapshotId
     * @return
     */
    SnapDataInfoDTO getSnapDataInfoBySnapshotId(String tenantId,String userId,String snapshotId);

    /**
     * 敏捷数据-大屏快照
     * @param tenantId
     * @param userId
     * @param sceneCode
     * @return
     */
    SnapDataInfoDTO getScreenSnapData(String tenantId,String userId,String sceneCode);

    /**
     * 敏捷数据-大屏实时数据
     * @param authoredUser
     * @param agileDataMoreActionDTO
     * @param local
     * @return
     */
    SnapDataInfoDTO getScreenSnapSyncData(AuthoredUser authoredUser, AgileDataMoreActionDTO agileDataMoreActionDTO,String local);



    /**
     * 获取快照数据
     * @param agileReportDetailParamsDTO
     * @param user
     * @return
     */
    List<Map<String,Object>> getSnapShotDetail(AgileReportDetailParamsDTO agileReportDetailParamsDTO, AuthoredUser user);

    /**
     * 获取快照数据
     * @param agileReportDetailParamsDTO
     * @param user
     * @return
     */
    Map<String,Object> getSnapPageShotDetail(AgileReportDetailParamsDTO agileReportDetailParamsDTO, AuthoredUser user);

    /**
     * 场景敏捷数据
     * @param sceneDTO
     * @param user
     * @return
     */
    List<Map<String,Object>> getScencDetail(SDScencDTO sceneDTO, AuthoredUser user);

    /**
     * 获取快照人员
     * @param snapshotId
     * @return
     */
    List<SnapData> getSnapShotUserList(String snapshotId);

    /**
     * 获取快照数据
     * @param tenantId
     * @param userId
     * @return
     */
    SnapShotDTO getSnapShotData(String snapshotId,String tenantId,String userId);

    /**
     * 从agile_data表中，按tenantId和userId获取dmcId
     * @param tenantId
     * @param userId
     * @return dmcId
     */
    String getDmcId(String snapshotId, String tenantId, String userId);

    /**
     * 更新读取次数，调用一次+1
     * @param snapshotId
     * @param tenantId
     * @param userId
     */
    void updateReadCount(String snapshotId, String tenantId, String userId);

    /**
     * 删除快照
     * @param snapshotId
     * @param tenantId
     * @param userId
     */
    void deleteSnap(String snapshotId, String tenantId, String userId);

    /**
     *  更新快照状态
     * @param snapshotId
     * @param tenantId
     * @param userId
     */
    Integer updateSnapsStatue (String snapshotId, String tenantId, String userId);

    /**
     * 根据快照id 获取aam信息
     * @param snapshotId 快照id
     * @param tenantId 租户id
     * @param userId 用户id
     * @return aamData
     */
    AamDataResDTO getAamDataBySnapshotId(String snapshotId, String tenantId, String userId);

    /**
     * 敏数提供第三方数据查询
     * @param snapshotId
     * @param authoredUser
     * @return
     */
    Map<String,Object> getThirdPartyAgileData(String snapshotId,AuthoredUser authoredUser);

    /**
     * 转换原始数据结构
     * @param agileTransDataDTO
     * @param authoredUser
     * @return
     */
    SnapDataInfoDTO transAgileData(AgileTransDataDTO agileTransDataDTO, AuthoredUser authoredUser,String lang);

    /**
     * 获取筛选过滤数据
     * @param request
     * @param filterDataDTO
     * @param authoredUser
     * @param lang
     * @return
     */
    AgileDatFilterDTO filterAgileData(HttpServletRequest request,AniaAssistantChatReqDTO filterDataDTO, AuthoredUser authoredUser, String lang);

    /**
     * 获取可转换图形列表
     * @param agileTransDataDTO
     * @param authoredUser
     * @return
     */
    List<String> getTransList(AgileTransDataDTO agileTransDataDTO, AuthoredUser authoredUser,String lang);

    Map<String, Object> getSolutionStepBySnapshotId(String snapshotId, String tenantId, String userId);
}
