package com.digiwin.athena.adt.agileReport.service.impl;

import com.digiwin.athena.adt.agileReport.service.ChartSnapshotService;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataChartSnapshot;
import com.digiwin.athena.adt.domain.repository.mongo.AgileDataChartSnapshotRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ChartSnapshotServiceImpl implements ChartSnapshotService {

    @Autowired
    @Qualifier("agileDataChartSnapshotRepository")
    private AgileDataChartSnapshotRepository repository;

    @Override
    public void saveSnapshot(AgileDataChartSnapshot snapshot) {
        if (snapshot == null || StringUtils.isBlank(snapshot.getSnapshotId()) || StringUtils.isBlank(snapshot.getChartType())) {
            throw new IllegalArgumentException("snapshotId/chartType不能为空");
        }
        if (snapshot.getSnapshotContent() == null || snapshot.getSnapshotContent().isEmpty()) {
            throw new IllegalArgumentException("snapshotContent不能为空");
        }

        repository.saveOrUpdate(snapshot);
    }

    @Override
    public AgileDataChartSnapshot getBySnapshotId(String snapshotId, String chartType) {
        if (StringUtils.isBlank(snapshotId) || StringUtils.isBlank(chartType)) {
            throw new IllegalArgumentException("snapshotId/chartType不能为空");
        }
        return repository.findBySnapshotIdAndChartType(snapshotId, chartType);
    }
}