package com.digiwin.athena.adt.agileReport.service.impl.aiBoard;

import com.digiwin.athena.adt.agileReport.controller.dto.AIBoardGenerateRes;
import com.digiwin.athena.adt.agileReport.service.AIBoardService;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.km.AgileDataQueryBoardAddDTO;
import com.digiwin.athena.adt.domain.dto.km.AgileDataQueryBoardDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class AIBoardServiceImpl implements AIBoardService {

    @Autowired
    private EchoService echoService;

    @Autowired
    private KmService kmService;

    @Override
    public AIBoardGenerateRes generateAIBoard(AuthoredUser authoredUser, Long messageId, String locale) {
        AIBoardGenerateRes aiBoardGenerateRes = new AIBoardGenerateRes();
        aiBoardGenerateRes.setResult(true);
        //获取可执行问句
        Map<String,Object> queryParams = Maps.newHashMap();
        queryParams.put("messageId",messageId);
        AIBoardDTO aiBoardDTO = echoService.getAIBoard(queryParams, authoredUser.getToken(), authoredUser.getTenantId());
        if(aiBoardDTO == null){
            aiBoardGenerateRes.setResult(false);
            aiBoardGenerateRes.setErrorMessage("未查询到该看板信息，无法生成");
            return aiBoardGenerateRes;
        }
        //生成看板
        AgileDataQueryBoardAddDTO boardAddDTO = new AgileDataQueryBoardAddDTO();
        AgileDataQueryBoardAddDTO.BoardConfig config = new AgileDataQueryBoardAddDTO.BoardConfig();
        config.setAsaCode(aiBoardDTO.getAppCode());
        config.setBoardName(aiBoardDTO.getBoardTitle());
        config.setMessageId(aiBoardDTO.getMessageId());
        config.setDataEntry("aiBoard");
        config.setUserId(authoredUser.getUserId());
        config.setTenantId(authoredUser.getTenantId());
        List<AgileDataQueryBoardAddDTO.DataBoardQuestion> dataBoardQuestions = Lists.newArrayList();
        config.setDataBoardQuestions(dataBoardQuestions);
        boardAddDTO.setConfig( config);
        if(CollectionUtils.isNotEmpty(aiBoardDTO.getQuestionInfo())){
            aiBoardDTO.getQuestionInfo().forEach(questionInfo -> {
                if(questionInfo.getAnalyzeStatus() == null || questionInfo.getAnalyzeStatus() != 0){
                    return;
                }
                AgileDataQueryBoardAddDTO.DataBoardQuestion dataBoardQuestion = new AgileDataQueryBoardAddDTO.DataBoardQuestion();
                dataBoardQuestion.setAppCode(aiBoardDTO.getAppCode());
                Map<String,Object> dataParam = Maps.newHashMap();
                dataParam.put("questionId",questionInfo.getQuestionId());
                dataParam.put("adeRequest",questionInfo.getGetDataParams());
                dataBoardQuestion.setDataParam(dataParam);
                dataBoardQuestion.setQuestion((questionInfo.getQuestion()));
                dataBoardQuestion.setFilterAnalysis(false);
                dataBoardQuestions.add(dataBoardQuestion);
            });
        }
        Map<String,Object> addResult = kmService.addBoardInfo(authoredUser, boardAddDTO);
        if(MapUtils.isEmpty(addResult)){
            aiBoardGenerateRes.setResult(false);
            aiBoardGenerateRes.setErrorMessage("生成看板失败");
        }
        Map<String,Object> response = MapUtils.getMap(addResult, "response");
        String boardId = MapUtils.getString(response,"boardId");
        aiBoardGenerateRes.setBoardId(boardId);
        AIBoardDTO updateAiBoardDTO = new AIBoardDTO();
        updateAiBoardDTO.setBoardId(boardId);
        updateAiBoardDTO.setMessageId(messageId);
        echoService.updateAIBoard(updateAiBoardDTO,authoredUser.getToken(),authoredUser.getTenantId());
        return aiBoardGenerateRes;
    }
}
