package com.digiwin.athena.adt.agileReport.service.impl.autoData;

import com.digiwin.athena.adt.agileReport.controller.dto.*;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataAutoDataService;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.ContextDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AgileDataAutoDataServiceImpl extends AbsAgileDataProcess implements AgileDataAutoDataService {

    @Autowired
    private AgileDataMessageService agileDataMessageService;

    @Autowired
    private EchoService echoService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private FileParsingService fileParsingService;

    @Autowired
    private DmcService dmcService;

    /**
     * 获取分析师数据
     * @param authoredUser
     * @return
     */
    @Override
    public AgileDataAutoDataRes getData(HttpServletRequest request,AuthoredUser authoredUser, AgileDataAutoDataReq autoDataReq) {
        log.info("获取执行实时总结数据入参：{}", JsonUtils.objectToString(autoDataReq));
        AgileDataAutoDataRes agileDataAutoDataRes = new AgileDataAutoDataRes();
        agileDataAutoDataRes.setQueryResult(true);
        //组装问句结构入参
        AniaAssistantChatReqDTO aniaAssistantChatReqDTO = this.buildAutoDataQuestionParams(request,autoDataReq);
        //ade入参
        SnapShotDTO snapshotInfo = this.buildAutoDataSnapParams(autoDataReq);
        //个性化入参
        ThemeMapBoardDTO themeMapBoardDTO = this.buildAutoDataBoardParams(autoDataReq);
        AthenaMessageEvent event = this.assemblyVersionInitEvent(request,aniaAssistantChatReqDTO,authoredUser);
        AgileDataProcessResDTO res = agileDataMessageService.processResV2(event,snapshotInfo,themeMapBoardDTO,null);
        if(res.getPanelMap() == null || res.getPanelMap().getContext() == null || res.getPanelMap().getContext().getBizParams() == null
            || CollectionUtils.isEmpty(res.getPanelMap().getContext().getPullData())){
            agileDataAutoDataRes.setQueryResult(false);
            return agileDataAutoDataRes;
        }
        PullDataDTO pullDataDTO = res.getPanelMap().getContext().getPullData().stream().findFirst().orElse(null);
        if(pullDataDTO == null){
            agileDataAutoDataRes.setQueryResult(false);
            return agileDataAutoDataRes;
        }

        agileDataAutoDataRes.setExceedSummarizeSize(res.getPanelMap().getContext().getBizParams().getExceedSummarizeSize());
        agileDataAutoDataRes.setSummarizeData(pullDataDTO.getSummarizeData());
        return agileDataAutoDataRes;
    }

    @Override
    public AgileDataAutoDataDTO getReportData(HttpServletRequest request, AuthoredUser authoredUser, AutoDataGenerateReportReq autoDataReq) {
        AgileDataAutoDataDTO autoDataDTO = new AgileDataAutoDataDTO();
        autoDataDTO.setMessageId(autoDataReq.getMessageId());
        autoDataDTO.setStatus("0");
        AgileDataAutoDataDTO data = echoService.getAutoDataReport(authoredUser,autoDataDTO);
        if(StringUtils.isEmpty( data.getShowDmcId())){
            return data;
        }
        Map<String,Object> dmcAgileData = dmcService.getDmcAgileData(data.getShowDmcId());
        data.setAutoDataAnalyzeText(this.buildHistoryText(dmcAgileData));
        data.setAutoDataAnalyzeList(this.buildHistoryList(dmcAgileData));
        return data;
    }

    /**
     * 获取下载链接
     * @param request
     * @param authoredUser
     * @param req
     * @return
     */
    @Override
    public AutoDataDownLoadDTO getDownLoadInfo(HttpServletRequest request, AuthoredUser authoredUser, AutoDataDownLoadReq req) {
        String locale = request.getHeader("locale");
        AutoDataDownLoadDTO autoDataDownLoad = new AutoDataDownLoadDTO();
        //获取消息信息
        AgileDataAutoDataDTO autoDataDTO = new AgileDataAutoDataDTO();
        autoDataDTO.setMessageId(req.getMessageId());
        autoDataDTO.setStatus("0");
        AgileDataAutoDataDTO agileDataAutoDataDTO = echoService.getAutoDataReport(authoredUser,autoDataDTO);
        if(agileDataAutoDataDTO == null){
            log.error("分析师文件不存在，消息ID:{}",req.getMessageId());
            autoDataDownLoad.setResult(false);
            autoDataDownLoad.setMessage(messageUtil.getMessageByLangNameWithFormat("message.adt.getDownLoadReport.error",locale));
            return autoDataDownLoad;
        }
        //存在链接，直接返回
        if(StringUtils.equals("pdf",req.getDownLoadType()) &&
            StringUtils.isNotEmpty(agileDataAutoDataDTO.getPdfUrl())){
            autoDataDownLoad.setResult(true);
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataDTO.getPdfUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataDTO.getPdfCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataDTO.getPdfExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataDTO.getLimitDay());
            return autoDataDownLoad;
        }
        if(StringUtils.equals("docx",req.getDownLoadType()) &&
                StringUtils.isNotEmpty(agileDataAutoDataDTO.getWordUrl())){
            autoDataDownLoad.setResult(true);
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataDTO.getWordUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataDTO.getWordCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataDTO.getWordExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataDTO.getLimitDay());
            return autoDataDownLoad;
        }
        //获取报告信息
        if(StringUtils.isEmpty(agileDataAutoDataDTO.getShowDmcId())){
            log.error("分析师DMC文件不存在，消息ID:{}",req.getMessageId());
            autoDataDownLoad.setResult(false);
            autoDataDownLoad.setMessage(messageUtil.getMessageByLangNameWithFormat("message.adt.getDownLoadReport.error",locale));
            return autoDataDownLoad;
        }
        Map<String,Object> processStreamData = dmcService.getDmcAgileData(agileDataAutoDataDTO.getShowDmcId());
        Map<String,Object> reportGeneration = MapUtils.getMap(processStreamData, "reportGeneration");
        String markdown = MapUtils.getString(reportGeneration, "content");
        //生成下载报告
        Map<String,Object> params = Maps.newHashMap();
        params.put("userId",authoredUser.getUserId());
        params.put("tenantId",authoredUser.getTenantId());
        params.put("fileName",agileDataAutoDataDTO.getFileName());
        params.put("markdownData",markdown);
        params.put("fileType",req.getDownLoadType());
        AgileDataAutoDataReportDTO agileDataAutoDataReportDTO = fileParsingService.getFileParsingAutoDataReport(authoredUser.getTenantId(), authoredUser.getToken(), locale, params);
        if(agileDataAutoDataReportDTO == null || !StringUtils.equals("200",agileDataAutoDataReportDTO.getCode())){
            log.error("获取分析师报告失败：分析入参：{}",JsonUtils.objectToString(params));
            autoDataDownLoad.setResult(false);
            if(agileDataAutoDataReportDTO == null) {
                autoDataDownLoad.setMessage(messageUtil.getMessageByLangNameWithFormat("message.adt.getDownLoadReport.error", locale));
            } else {
                autoDataDownLoad.setMessage(agileDataAutoDataReportDTO.getMessage());
            }
            return autoDataDownLoad;
        }
        //存入消息结果
        AgileDataAutoDataDTO updateAutoDataDTO = new AgileDataAutoDataDTO();
        updateAutoDataDTO.setMessageId(req.getMessageId());
        updateAutoDataDTO.setLimitDay(agileDataAutoDataReportDTO.getData().getLimitDay());
        if(StringUtils.equals("pdf",req.getDownLoadType())) {
            updateAutoDataDTO.setPdfUrl(agileDataAutoDataReportDTO.getData().getPdf().getUrl());
            updateAutoDataDTO.setPdfCreateDate(agileDataAutoDataReportDTO.getData().getPdf().getCreateDate());
            updateAutoDataDTO.setPdfExpireDate(agileDataAutoDataReportDTO.getData().getPdf().getExpireDate());
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataReportDTO.getData().getPdf().getUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataReportDTO.getData().getPdf().getCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataReportDTO.getData().getPdf().getExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataReportDTO.getData().getLimitDay());
        }
        if(StringUtils.equals("docx",req.getDownLoadType())) {
            updateAutoDataDTO.setWordUrl(agileDataAutoDataReportDTO.getData().getDocx().getUrl());
            updateAutoDataDTO.setWordCreateDate(agileDataAutoDataReportDTO.getData().getDocx().getCreateDate());
            updateAutoDataDTO.setWordExpireDate(agileDataAutoDataReportDTO.getData().getDocx().getExpireDate());
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataReportDTO.getData().getDocx().getUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataReportDTO.getData().getDocx().getCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataReportDTO.getData().getDocx().getExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataReportDTO.getData().getLimitDay());
        }
        echoService.updateAutoDataReport(authoredUser, updateAutoDataDTO);
        return autoDataDownLoad;
    }

    private AniaAssistantChatReqDTO buildAutoDataQuestionParams(HttpServletRequest request,AgileDataAutoDataReq autoDataReq){
        AniaAssistantChatReqDTO aniaAssistantChatReqDTO = new AniaAssistantChatReqDTO();
        aniaAssistantChatReqDTO.setAssistantId(autoDataReq.getAppCode());
        AniaAssistantChatReqDTO.Message message = new AniaAssistantChatReqDTO.Message();
        Map<String,Object> extData = Maps.newHashMap();
        Map<String,Object> msgExt = Maps.newHashMap();
        msgExt.put("msg",autoDataReq.getQuestion());
        msgExt.put("asaCode",autoDataReq.getQuestion());
        //自定义入参
        Map<String,Object> msgBody = Maps.newHashMap();
        msgBody.put("msg",autoDataReq.getQuestion());
        extData.put("msgBody",msgBody);
        extData.put("msgExt",msgExt);
        message.setExtData(extData);
        aniaAssistantChatReqDTO.setMessage(message);
        return aniaAssistantChatReqDTO;
    }

    private SnapShotDTO buildAutoDataSnapParams(AgileDataAutoDataReq autoDataReq){
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        ContextDTO contextDTO = new ContextDTO();
        snapShotDTO.setContext(contextDTO);
        BizParamsDTO bizParamsDTO = new BizParamsDTO();
        bizParamsDTO.setShowDefine(CommonUtil.convertObjectToMap(autoDataReq.getShowDefine()));
        bizParamsDTO.setDatasetList(autoDataReq.getDatasetList());
        bizParamsDTO.setQuestion(autoDataReq.getQuestion());
        contextDTO.setBizParams(bizParamsDTO);
        return snapShotDTO;
    }

    private ThemeMapBoardDTO buildAutoDataBoardParams(AgileDataAutoDataReq autoDataReq){
        ThemeMapBoardDTO themeMapBoardDTO = new ThemeMapBoardDTO();
        Map<String,Object> solutionStep = Maps.newHashMap();
        String actionId = autoDataReq.getShowDefine().getShowType().get(0).getActionId();
        solutionStep.put(actionId,autoDataReq.getSolutionStep());
        themeMapBoardDTO.setAppCode(autoDataReq.getAppCode());
        themeMapBoardDTO.setSolutionStep(solutionStep);
        themeMapBoardDTO.setFilterAnalysis(false);
        return themeMapBoardDTO;
    }

    private String buildHistoryText(Map<String,Object> processStreamData){
        StringBuilder historyText = new StringBuilder();
        if(MapUtils.isEmpty(processStreamData)){
            return historyText.toString();
        }
        Map<String,Object> intentionAnalysis4AutoData = MapUtils.getMap(processStreamData, "intentionAnalysis4AutoData");
        historyText.append(MapUtils.getString(intentionAnalysis4AutoData, "title"));
        historyText.append(MapUtils.getString(intentionAnalysis4AutoData, "content"));
        Map<String,Object> taskPlan = MapUtils.getMap(processStreamData, "taskPlan");
        historyText.append(MapUtils.getString(taskPlan, "title"));
        historyText.append(MapUtils.getString(taskPlan, "content"));
        Map<String,Object> dataQuery = MapUtils.getMap(processStreamData, "dataQuery");
        historyText.append(MapUtils.getString(dataQuery, "title"));
        historyText.append(MapUtils.getString(dataQuery, "content"));
        Map<String,Object> dataFusionAnalysis = MapUtils.getMap(processStreamData, "dataFusionAnalysis");
        historyText.append(MapUtils.getString(dataFusionAnalysis, "title"));
        historyText.append(MapUtils.getString(dataFusionAnalysis, "content"));
        Map<String,Object> reportGeneration = MapUtils.getMap(processStreamData, "reportGeneration");
        historyText.append(MapUtils.getString(reportGeneration, "title"));
        historyText.append(MapUtils.getString(reportGeneration, "content"));
        return historyText.toString();
    }

    private List<Map<String,Object>> buildHistoryList(Map<String,Object> processStreamData){
        List<Map<String,Object>> historyList = Lists.newArrayList();
        if(MapUtils.isEmpty(processStreamData)){
            return historyList;
        }
        Map<String,Object> intentionAnalysis4AutoData = MapUtils.getMap(processStreamData, "intentionAnalysis4AutoData");
        historyList.add(this.buildAutoDataReportContent("function_analysic","title",MapUtils.getString(intentionAnalysis4AutoData, "title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic","text",MapUtils.getString(intentionAnalysis4AutoData, "content")));


        Map<String,Object> taskPlan = MapUtils.getMap(processStreamData, "taskPlan");
        historyList.add(this.buildAutoDataReportContent("function_analysic","title",MapUtils.getString(taskPlan, "title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic","text",MapUtils.getString(taskPlan, "content")));

        Map<String,Object> dataQuery = MapUtils.getMap(processStreamData, "dataQuery");
        historyList.add(this.buildAutoDataReportContent("function_analysic","title",MapUtils.getString(dataQuery, "title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic","text",MapUtils.getString(dataQuery, "content")));

        Map<String,Object> dataFusionAnalysis = MapUtils.getMap(processStreamData, "dataFusionAnalysis");
        historyList.add(this.buildAutoDataReportContent("function_analysic","title",MapUtils.getString(dataFusionAnalysis, "title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic","text",MapUtils.getString(dataFusionAnalysis, "content")));

        Map<String,Object> reportGeneration = MapUtils.getMap(processStreamData, "reportGeneration");
        historyList.add(this.buildAutoDataReportContent("function_answer","text",MapUtils.getString(reportGeneration, "content")));

        return historyList;
    }

    private Map<String,Object> buildAutoDataReportContent(String eventType,String messageType,String content){
        Map<String,Object> autoDataReport = Maps.newHashMap();
        autoDataReport.put("eventType",eventType);
        autoDataReport.put("messageType",messageType);
        autoDataReport.put("content",content);
        return autoDataReport;
    }

}
