package com.digiwin.athena.adt.agileReport.service.impl.hook;

import com.digiwin.athena.adt.agileReport.service.AgileDataConfigService;
import com.digiwin.athena.adt.agileReport.service.AgileDataPageHooksService;
import com.digiwin.athena.adt.domain.dto.AgileDataPageViewDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/***
 * 敏捷数据呈现hooks配置
 */
@Slf4j
@Service
public class AgileDataPageHooksServiceImpl implements AgileDataPageHooksService {

    @Autowired
    @Qualifier("mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    private static final String MONGODB_COLLECTION_NAME = "agile_data_pageView";

    private static String keyPrefix = "adt:cache:";

    @Autowired
    private StringRedisTemplate stringRedisTemplate;


    /**
     * 新增hooks
     * @param authoredUser
     * @return
     */
    @Override
    public Boolean createAgileDataPageHooks(AuthoredUser authoredUser,
                                            Map<String,Object> params) {
        String type = MapUtils.getString(params,"type");
        Integer version = MapUtils.getInteger(params,"version");
        if(StringUtils.isEmpty(type)){
            return false;
        }
        Query query = Query.query(Criteria.where("type").is(type).and("version").is(version));
        AgileDataPageViewDTO agileDataPageViewDTO = mongoAgileDataPageViewTemplate.findOne(query, AgileDataPageViewDTO.class, MONGODB_COLLECTION_NAME);
        if(agileDataPageViewDTO == null){
            AgileDataPageViewDTO pageViewDTO = new AgileDataPageViewDTO();
            pageViewDTO.setType(type);
            pageViewDTO.setVersion(version);
            pageViewDTO.setHooks((List<Map<String, Object>>) MapUtils.getObject(params,"hooks"));
            mongoAgileDataPageViewTemplate.insert(pageViewDTO,MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("hooks",MapUtils.getObject(params,"hooks"));
            mongoAgileDataPageViewTemplate.upsert(query,update,AgileDataPageViewDTO.class,MONGODB_COLLECTION_NAME);
            stringRedisTemplate.delete(keyPrefix + type);
        }

        return true;
    }



    /**
     * 获取hooks
     * @param authoredUser
     * @return
     */
    @Override
    public AgileDataPageViewDTO queryAgileDataPageHooks(AuthoredUser authoredUser,String type) {
        Query query = Query.query(Criteria.where("type").is(type).and("version").is(1));
        AgileDataPageViewDTO agileDataPageViewDTO = mongoAgileDataPageViewTemplate.findOne(query, AgileDataPageViewDTO.class, MONGODB_COLLECTION_NAME);
        return agileDataPageViewDTO;
    }
}
