package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataLogService;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageLogEventService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 日志记录s
 */
@Slf4j
@Service
public class AgileDataLogServiceImpl implements AgileDataLogService {

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataMessageLogEventService agileDataMessageLogEventService;

    @Override
    public void saveAgileDataLog(AgileDataLogEvent event) {
        agileDataMessageLogEventService.processLog(event);
    }

    @Override
    public void saveQuestionData(Map<String, Object> data, AgileDataLogEvent event) {
        Map<String,Object> dataMap = Maps.newHashMap();
        String snapshotId = "";
        String tipMessage = messageUtil.getMessageByLangName("message.log.error", event.getLocal());
        //数据不为空，进行日志记录
        if(MapUtils.isNotEmpty(data)){
            snapshotId = MapUtils.getString(data,"snapshotId");
            Map<String,Object> contextMap = MapUtils.getMap(data,"context");
            if(MapUtils.isNotEmpty(contextMap) && contextMap.containsKey("pullData")){
                List<Map<String,Object>> dataList = (List<Map<String, Object>>) MapUtils.getObject(contextMap,"pullData");
                if(!CollectionUtils.isEmpty(dataList)){
                    event.setMessageGet(true);
                    //按actionId分组
                    Map<String, List<Map<String, Object>>> groupMap = dataList.stream()
                            .collect(Collectors.groupingBy(map -> (String) map.get("actionId")));
                    //取actionId下的业务数据
                    if(MapUtils.isNotEmpty(groupMap)){
                        groupMap.forEach((k,v) -> {
                            List<Map<String,Object>> bkDataList = Lists.newArrayList();
                            //获取actionID下的所有业务数据
                            v.stream().forEach(groupData -> {
                                Object dataObj = MapUtils.getObject(groupData, "data");
                                if(dataObj != null && !((Map) dataObj).isEmpty()) {
                                    List<Map<String, Object>> tempList = Lists.newArrayList();
                                    if (dataObj instanceof Map) {
                                        tempList.add((Map<String, Object>) dataObj);
                                    } else {
                                        tempList.addAll((Collection<? extends Map<String, Object>>) dataObj);
                                    }
                                    if(!CollectionUtils.isEmpty(tempList)){
                                        bkDataList.addAll(tempList);
                                    }
                                }
                            });
                            if(!CollectionUtils.isEmpty(bkDataList)) {
                                dataMap.put(k, bkDataList);
                            }
                        });
                    }
                }
            }
            event.setData(dataMap);
            event.setSnapshotId(snapshotId);
            event.setSuccess(1);
            event.setType(0);
            event.setErrorAnswer(MapUtils.isNotEmpty(dataMap) ? null: tipMessage);
            agileDataMessageLogEventService.processLog(event);
        }
    }
}
