package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.dao.AgileDataLogMapper;
import com.digiwin.athena.adt.agileReport.dao.AgileDataLogSqlMapper;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMysqlService;
import com.digiwin.athena.adt.domain.dto.km.KMPurchaseModelResDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.po.AgileDataLog;
import com.digiwin.athena.adt.domain.po.AgileDataLogSql;
import com.digiwin.athena.adt.util.DateUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 记录mysql日志
 */
@Slf4j
@Service
public class AgileReportLogMysqlServiceImpl implements AgileReportLogMysqlService {

    @Autowired
    private AgileDataLogMapper agileDataLogMapper;

    @Autowired
    private AgileDataLogSqlMapper agileDataLogSqlMapper;

    @Autowired
    private KmService kmService;

    private static final String TENANT_ID = "tenant_id";
    private static final String USER_ID = "user_id";
    private static final String GENERATESERIALNO = "generate_serial_no";
    private static final String SNAPSHOT_ID = "snapshot_id";

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveLog(AgileDataLogEvent agileDataLogEvent,Map<String, Object> schemaMap) {
        //查询是否存在记录
        QueryWrapper<AgileDataLog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(TENANT_ID, agileDataLogEvent.getAuthoredUser().getTenantId())
                .eq(USER_ID, agileDataLogEvent.getAuthoredUser().getUserId())
                .eq(GENERATESERIALNO,agileDataLogEvent.getGenerateSerialNo());
        AgileDataLog dataLog = agileDataLogMapper.selectOne(queryWrapper);
        //无数据进行新增操作
        if(dataLog == null) {
            AgileDataLog agileDataLog = new AgileDataLog();
            BeanUtils.copyProperties(agileDataLogEvent, agileDataLog);
            // 校验应用是否为空,如果为空且该用户只有唯一应用则存当前应用
            this.checkAppCode(agileDataLogEvent,agileDataLog);
            agileDataLog.setUserName(agileDataLogEvent.getAuthoredUser().getUserName());
            agileDataLog.setUserId(agileDataLogEvent.getAuthoredUser().getUserId());
            agileDataLog.setTenantId(agileDataLogEvent.getAuthoredUser().getTenantId());
            agileDataLog.setTenantName(agileDataLogEvent.getAuthoredUser().getTenantName());
            agileDataLog.setCreateTime(agileDataLogEvent.getAskTime());
            agileDataLog.setAnswerTime(agileDataLogEvent.getAnswerTime());
            agileDataLog.setResSecTime(DateUtils.calculateAndSetDuration(agileDataLogEvent.getAskTime(),
                    agileDataLogEvent.getAnswerTime()));
            agileDataLogMapper.insert(agileDataLog);
            //获取sql条件
            if (MapUtils.isNotEmpty(schemaMap) && schemaMap.containsKey("sqlSchemaMaps")) {
                Map<String, Object> sqlSchemaMaps = MapUtils.getMap(schemaMap, "sqlSchemaMaps");
                if (MapUtils.isNotEmpty(sqlSchemaMaps)) {
                    List<AgileDataLogSql> agileDataLogSqlList = Lists.newArrayList();
                    sqlSchemaMaps.forEach((k, v) -> {
                        AgileDataLogSql agileDataLogSql = new AgileDataLogSql();
                        agileDataLogSql.setLogId(agileDataLog.getId());
                        agileDataLogSql.setQueryTitle(k);
                        agileDataLogSql.setQuerySql(v.toString());
                        agileDataLogSqlList.add(agileDataLogSql);
                    });
                    agileDataLogSqlMapper.insertBatchSomeColumn(agileDataLogSqlList);
                }
            }
        } else {
            this.updateLog(agileDataLogEvent,dataLog);
        }
        return true;
    }

    /**
     * 校验应用是否为空,如果为空且该用户只有唯一应用则存当前应用
     */
    public void checkAppCode(AgileDataLogEvent agileDataLogEvent,AgileDataLog agileDataLog) {
        String token = agileDataLogEvent.getAuthoredUser().getToken();
        String tenantId = agileDataLogEvent.getAuthoredUser().getTenantId();
        String userId = agileDataLogEvent.getAuthoredUser().getUserId();
        String appCode = agileDataLogEvent.getApplicationCode();
        List<KMPurchaseModelResDTO> apps = kmService.queryKmPurchaseList(1,token,tenantId,userId);
        if(StringUtils.isEmpty(appCode) && apps.size() == 1){
            agileDataLog.setApplicationName(apps.get(0).getName());
            agileDataLog.setApplicationCode(apps.get(0).getCode());
        }
    }

    @Override
    public Boolean removeLog(AgileDataLogEvent agileDataLogEvent) {
        QueryWrapper<AgileDataLog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(TENANT_ID, agileDataLogEvent.getAuthoredUser().getTenantId())
                .eq(USER_ID, agileDataLogEvent.getAuthoredUser().getUserId())
                .eq(SNAPSHOT_ID,agileDataLogEvent.getSnapshotId());
        agileDataLogMapper.delete(queryWrapper);
        return true;
    }

    /**
     * 根据场景获取更新字段
     * @param agileDataLogEvent
     * @return
     */
    private void updateLog(AgileDataLogEvent agileDataLogEvent,AgileDataLog dataLog){
        AgileDataLog agileDataLog = new AgileDataLog();
        agileDataLog.setUserName(agileDataLogEvent.getAuthoredUser().getUserName());
        agileDataLog.setUserId(agileDataLogEvent.getAuthoredUser().getUserId());
        agileDataLog.setTenantId(agileDataLogEvent.getAuthoredUser().getTenantId());
        agileDataLog.setTenantName(agileDataLogEvent.getAuthoredUser().getTenantName());
        agileDataLog.setGenerateSerialNo(agileDataLogEvent.getGenerateSerialNo());
        switch (agileDataLogEvent.getType()){
            //异常日志
            case 1:
                agileDataLog.setErrorAnswer(agileDataLogEvent.getErrorAnswer());
                agileDataLog.setSuccess(agileDataLogEvent.getSuccess());
                break;
            //用户点赞/点踩
            case 2:
                agileDataLog.setFeedbackType(agileDataLogEvent.getFeedbackType());
                if(dataLog.getCreateBackTime() == null){
                    agileDataLog.setCreateBackTime(LocalDateTime.now());
                }
                break;
            //用户反馈
            case 3:
                agileDataLog.setAnswerOpinion(agileDataLogEvent.getAnswerOpinion());
                agileDataLog.setBackContent(agileDataLogEvent.getBackContent());
                agileDataLog.setCheckOpinions(agileDataLogEvent.getCheckOpinions());
                if(dataLog.getCreateBackTime() == null){
                    agileDataLog.setCreateBackTime(LocalDateTime.now());
                }
                break;
            //用户取消点赞/点踩
            case 4:
                agileDataLog.setFeedbackType(agileDataLogEvent.getFeedbackType());
                agileDataLog.setAnswerOpinion(agileDataLogEvent.getAnswerOpinion());
                agileDataLog.setBackContent(agileDataLogEvent.getBackContent());
                agileDataLog.setCheckOpinions(agileDataLogEvent.getCheckOpinions());
                agileDataLog.setCreateBackTime(null);
                break;
            default:
                break;
        }
        agileDataLog.setModifyTime(LocalDateTime.now());
        agileDataLogMapper.updateAgileDataLog(agileDataLog);
    }
}
