package com.digiwin.athena.adt.agileReport.service.impl.ppt;

import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTRes;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateReq;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateRes;
import com.digiwin.athena.adt.agileReport.service.AgileDataPPTService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.*;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaPPTPlanningDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * ppt服务
 */
@Slf4j
@Service
public class AgileDataPPTServiceImpl implements AgileDataPPTService {

    @Autowired
    private EchoService echoService;

    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private FileParsingService fileParsingService;

    @Override
    public AgileDataPPTRes getPPTAnalyze(AuthoredUser user, AgileDataPPTReq agileDataPPTReq, String locale) {
        log.info("开始重新生成规划，入参：{}",JsonUtils.objectToString(agileDataPPTReq));
        AgileDataPPTRes agileDataPPTRes = new AgileDataPPTRes();
        agileDataPPTRes.setResult(true);
        //是否需要执行
        Map<String,Object> params = Maps.newHashMap();
        params.put("messageId",agileDataPPTReq.getMessageId());
        AgileDataFileDTO agileDataFileDTO = echoService.getAgileDataFile(params,user.getToken(),user.getTenantId());
        if(agileDataFileDTO == null){
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        //全部所定，返回原有问句
        if(!isNeedExecute(agileDataFileDTO)){
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        //组装入参
        ScrumbiPPTAnalyzeDTO querySchemaResDTO = chatbiService.getPPTAnalyze(user,buildPPTParams(agileDataFileDTO,agileDataPPTReq),locale);
        //获取语义执行结果
        if(querySchemaResDTO == null){
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        //分析语义执行结果
        Object code = querySchemaResDTO.getData().getCode();
        if (Objects.isNull(code)) {
            log.info("分析语义规划获取失败，使用原结果");
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        QuerySchemaPPTPlanningDTO questionPlanningRes = querySchemaResDTO.getData().getContent();
        if (Objects.isNull(questionPlanningRes)) {
            log.info("分析语义规划获取失败，使用原结果");
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        switch (code.toString()) {
            // 成功分析问句
            case SchemaConstants.METRIC_SQL:
                Map<String,Object> deleteParams = Maps.newHashMap();
                deleteParams.put("messageId",agileDataPPTReq.getMessageId());
                //删除原有分析规划
                echoService.deleteAgileDataFile(deleteParams,user.getToken(),user.getTenantId());
                //生成新分析规划
                QuerySchemaResDTO schemaResDTO = new QuerySchemaResDTO();
                querySchemaResDTO.getData().getContent().setPlanningTopic(agileDataFileDTO.getMessageTopic());
                schemaResDTO.setQuestionPlanningRes(querySchemaResDTO.getData().getContent());
                //锁定状态更改
                agileDataFileDTO.getQuestionInfo().stream().forEach(question -> querySchemaResDTO.getData().getContent().getPlanningQuestions().stream().forEach(planningQuestion -> {
                    if(planningQuestion.getQuestion().equals(question.getQuestion())){
                        planningQuestion.setStatus(question.getLock() ? 0 : 1);
                    }
                }));
                AgileDataFileDTO agileDataFile = AgileDataAnalysisUtils.buildAgileDataFile(agileDataPPTReq.getMessageId(),agileDataFileDTO.getAppCode(),schemaResDTO);
                echoService.addAgileDataFile(agileDataFile,user.getToken(),user.getTenantId());
                agileDataPPTRes.setAnalyzeResult(agileDataFile);
                break;
            // 异常引导语句
            case SchemaConstants.SCHEMA_REPLY:
                agileDataPPTRes.setResult(false);
                agileDataPPTRes.setReplay(querySchemaResDTO.getData().getReply());
                break;
            default:
                break;
        }
        return agileDataPPTRes;
    }

    @Override
    public AgileDataGenerateRes generatePPT(AuthoredUser user, AgileDataGenerateReq agileDataGenerateReq, String locale) {
        log.info("开始生成PPT，入参：{}", JsonUtils.objectToString(agileDataGenerateReq));
        AgileDataGenerateRes agileDataGenerateRes = new AgileDataGenerateRes();
        agileDataGenerateRes.setPptStatus("0");
        //获取ppt问句信息
        Map<String,Object> getFileParams = Maps.newHashMap();
        getFileParams.put("messageId",agileDataGenerateReq.getMessageId());
        AgileDataFileDTO agileDataFileDTO = echoService.getAgileDataFile(getFileParams, user.getToken(), user.getTenantId());
        if(agileDataFileDTO == null){
            log.error("获取问句信息失败");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        //是否需要重新生成
        List<AgileDataFileDTO.AgileDataFileGenerateDTO> pptInfo = agileDataFileDTO.getPptInfo();
        if(CollectionUtils.isNotEmpty(pptInfo)){
            AgileDataFileDTO.AgileDataFileGenerateDTO pptGenerateDTO = pptInfo.stream().filter(ppt -> ppt.getPptId().equals(agileDataGenerateReq.getPptId())).findFirst().orElse(null);
            if(pptGenerateDTO != null && ("0").equals(pptGenerateDTO.getGenerateStatus())){
                agileDataGenerateRes.setPptUrl(pptGenerateDTO.getPptUrl());
                agileDataGenerateRes.setPptPreviewUrl(pptGenerateDTO.getPptPreviewUrl());
                agileDataGenerateRes.setPptDocId(pptGenerateDTO.getPptDocId());
                agileDataGenerateRes.setPptName(pptGenerateDTO.getPptName());
                agileDataGenerateRes.setCreateDate(pptGenerateDTO.getCreateDate());
                agileDataGenerateRes.setExpireDate(pptGenerateDTO.getExpireDate());
                agileDataGenerateRes.setPptPageSize(pptGenerateDTO.getPptPageSize());
                return agileDataGenerateRes;
            }
        }
        //更新ppt生成状态
        Boolean updateResult = echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "2",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
        if(!updateResult){
            echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
            log.error("获取问句信息失败");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        //获取ppt呈现结构
        Map<String,Object> params = Maps.newHashMap();
        params.put("snapshotIds",agileDataFileDTO.getQuestionInfo().stream()
                .filter(Objects::nonNull)
                .filter(question -> question.getAnalyzeStatus() != null && question.getAnalyzeStatus() == 0)
                .map(AgileDataFileDTO.AgileDataFileQuestionDTO::getSnapshotId)
                .filter(Objects::nonNull)
                .collect(Collectors.toList()));
        AgileDataFileShowDTO agileDataFileShowDTO = echoService.getAgileDataFileShow(params, user.getToken(), user.getTenantId());
        if(agileDataFileShowDTO == null){
            echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
            log.error("获取问句呈现结构失败");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        //通过智能体解析呈现结构
        ScrumbiGenaratePPTRes pptRes = chatbiService.generatePPT(user, this.buildPPTGenarateParams(agileDataFileShowDTO, agileDataFileDTO,user), locale);
        if(pptRes == null){
            echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
            log.error("获取PPT智能体失败");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        if(pptRes.getData() == null){
            echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
            log.error("获取PPT智能体失败");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        Integer code = pptRes.getData().getCode();
        switch (code){
            case 0:
                //生成ppt
                Map<String,Object> content = pptRes.getData().getContent();
                List<Map<String,Object>> pages = (List<Map<String,Object>>) content.get("pptPage");
                List<Map<String,Object>> datas = (List<Map<String,Object>>) content.get("pptData");
                String name = MapUtils.getString(content, "name");
                if(CollectionUtils.isEmpty(datas)){
                    echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
                    log.error("获取PPT智能体生成结构失败");
                    agileDataGenerateRes.setPptStatus("1");
                    agileDataGenerateRes.setErrMessage(messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
                    return agileDataGenerateRes;
                }
                FileParsingPPTRes fileParsingPPTRes = fileParsingService.getFileParsingPPT(user.getTenantId(), user.getToken(), locale,
                        this.buildFilePPTParams(user,name,datas,pages));
                if(fileParsingPPTRes == null || fileParsingPPTRes.getCode() != 200 || fileParsingPPTRes.getData() == null){
                    echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
                    log.error("生成PPT失败");
                    agileDataGenerateRes.setPptStatus("1");
                    agileDataGenerateRes.setErrMessage((fileParsingPPTRes != null && StringUtils.isNotEmpty(fileParsingPPTRes.getMsg()))
                            ? fileParsingPPTRes.getMsg() : messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
                    return agileDataGenerateRes;
                }
                //更新ppt生成状态
                echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "0",agileDataGenerateReq,fileParsingPPTRes), user.getToken(), user.getTenantId());
                agileDataGenerateRes.setPptUrl(fileParsingPPTRes.getData().getUrl());
                agileDataGenerateRes.setPptDocId(fileParsingPPTRes.getData().getPptDocId());
                agileDataGenerateRes.setPptPreviewUrl(fileParsingPPTRes.getData().getPptPreviewUrl());
                agileDataGenerateRes.setPptPageSize(fileParsingPPTRes.getData().getPptPageSize());
                agileDataGenerateRes.setPptName(fileParsingPPTRes.getData().getPptName());
                agileDataGenerateRes.setCreateDate(fileParsingPPTRes.getData().getCreateDate());
                agileDataGenerateRes.setExpireDate(fileParsingPPTRes.getData().getExpireDate());
                break;
            case 1:
                echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1",agileDataGenerateReq,null), user.getToken(), user.getTenantId());
                log.error("获取PPT智能体失败");
                agileDataGenerateRes.setPptStatus("1");
                agileDataGenerateRes.setErrMessage(pptRes.getData().getReply());
                break;
            default:
                break;
        }


        return agileDataGenerateRes;
    }

    private Map<String,Object> buildFilePPTParams(AuthoredUser authoredUser,String name,List<Map<String,Object>> datas,List<Map<String,Object>> pages){
        Map<String,Object> params = Maps.newHashMap();
        params.put("userId",authoredUser.getUserId());
        params.put("userName",authoredUser.getUserName());
        params.put("tenantId",authoredUser.getTenantId());
        params.put("pptData",datas);
        params.put("pptPage",pages);
        params.put("name",name);
        return params;
    }

    private ScrumbiGenaratePPTReq buildPPTGenarateParams(AgileDataFileShowDTO agileDataFileShowDTO,AgileDataFileDTO agileDataFileDTO,AuthoredUser user)
    {
        ScrumbiGenaratePPTReq scrumbiGenaratePPTReq = new ScrumbiGenaratePPTReq();
        scrumbiGenaratePPTReq.setPlanningTopic(agileDataFileDTO.getMessageTopic());
        scrumbiGenaratePPTReq.setUserId(user.getUserId());
        scrumbiGenaratePPTReq.setUserName(user.getUserName());
        scrumbiGenaratePPTReq.setTenantId(user.getTenantId());
        scrumbiGenaratePPTReq.setChartTypeMap(agileDataFileShowDTO.getTypeMap());
        List<ScrumbiGenaratePPTReq.QuestionAndAnswers> questionAndAnswers = Lists.newArrayList();
        scrumbiGenaratePPTReq.setPlanningQuestionAndAnswers(questionAndAnswers);
        if(CollectionUtils.isNotEmpty(agileDataFileDTO.getQuestionInfo())){
            agileDataFileDTO.getQuestionInfo().stream().forEach(questionInfo -> {
                //获取对应的呈现结构
                List<AgileDataFileShowDTO.AgileDataFileStandard> showDefines = agileDataFileShowDTO.getShowDefine().stream().
                        filter(showDefine -> showDefine.getSnapshotId().equals(questionInfo.getSnapshotId())).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(showDefines)){
                    showDefines.stream().forEach(showDefine -> {
                        ScrumbiGenaratePPTReq.QuestionAndAnswers questionAndAnswer = new ScrumbiGenaratePPTReq.QuestionAndAnswers();
                        questionAndAnswer.setQuestion(questionInfo.getQuestion());
                        questionAndAnswer.setTitle(questionInfo.getTitle());
                        questionAndAnswer.setAnswer(showDefine.getAbstractComponent());
                        questionAndAnswer.setSummary(questionInfo.getSummarizeData());
                        questionAndAnswers.add(questionAndAnswer);
                    });
                }
            });
        }
        return scrumbiGenaratePPTReq;
    }

    private AgileDataFileDTO buildUpdateStatusParams(AgileDataFileDTO agileDataFile,String status,AgileDataGenerateReq agileDataGenerateReq,
                                                     FileParsingPPTRes fileParsingPPTRes){
        AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
        agileDataFileDTO.setMessageId(agileDataGenerateReq.getMessageId());
        List<AgileDataFileDTO.AgileDataFileGenerateDTO> pptInfo = agileDataFile.getPptInfo();
        AgileDataFileDTO.AgileDataFileGenerateDTO pptInfoDTO = new AgileDataFileDTO.AgileDataFileGenerateDTO();
        pptInfoDTO.setPptId(agileDataGenerateReq.getPptId());
        pptInfoDTO.setGenerateStatus(status);
        if(fileParsingPPTRes != null && fileParsingPPTRes.getData() != null){
            pptInfoDTO.setPptUrl(fileParsingPPTRes.getData().getUrl());
            pptInfoDTO.setPptPreviewUrl(fileParsingPPTRes.getData().getPptPreviewUrl());
            pptInfoDTO.setPptDocId(fileParsingPPTRes.getData().getPptDocId());
            pptInfoDTO.setPptName(fileParsingPPTRes.getData().getPptName());
            pptInfoDTO.setCreateDate(fileParsingPPTRes.getData().getCreateDate());
            pptInfoDTO.setExpireDate(fileParsingPPTRes.getData().getExpireDate());
            pptInfoDTO.setPptPageSize(fileParsingPPTRes.getData().getPptPageSize());
        }
        pptInfo.add(pptInfoDTO);
        agileDataFileDTO.setPptInfo(pptInfo);
        return agileDataFileDTO;
    }


    /**
     * 是否需要调用语义执行
     * @param agileDataFileDTO
     * @return
     */
    private Boolean isNeedExecute(AgileDataFileDTO agileDataFileDTO){
        List<AgileDataFileDTO.AgileDataFileQuestionDTO> unLock;
        if(agileDataFileDTO != null){
            List<AgileDataFileDTO.AgileDataFileQuestionDTO> planningQuestions = agileDataFileDTO.getQuestionInfo();
            //只有满足8条时，才会判断是否锁定
            if(CollectionUtils.isNotEmpty(planningQuestions) && planningQuestions.size() == 8){
                //是否存在未锁定的问句
                unLock = planningQuestions.stream().filter(question -> !question.getLock()).collect(Collectors.toList());
                return CollectionUtils.isNotEmpty(unLock);
            }
        }
        return true;
    }

    /**
     * 组装问句参数
     * @param agileDataFileDTO
     * @param agileDataPPTReq
     * @return
     */
    private Map<String,Object> buildPPTParams(AgileDataFileDTO agileDataFileDTO,AgileDataPPTReq agileDataPPTReq){
        //查询问句信息
        Map<String,Object> res = Maps.newHashMap();
        if(agileDataFileDTO == null){
            return res;
        }
        //分析规划信息
        res.put("question",agileDataPPTReq.getQuestion());
        res.put("planningTopic",agileDataFileDTO.getMessageTopic());
        List<Map<String,Object>> planningQuestions = Lists.newArrayList();
        agileDataFileDTO.getQuestionInfo().stream().forEach(question -> {
            Map<String,Object> planningQuestion = Maps.newHashMap();
            planningQuestion.put("question",question.getQuestion());
            planningQuestion.put("title",question.getTitle());
            planningQuestion.put("datasetIds",question.getDatasetIds());
            planningQuestion.put("status",question.getLock() ? 1 : 0);
            planningQuestions.add(planningQuestion);
        });
        res.put("planningQuestions",planningQuestions);
        res.put("measures",agileDataPPTReq.getMeasures());
        return res;
    }
}
