package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeResDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.AI_BOARD_ANALYZE)
public class AgileDataProcessAIBoardAnalyzeServiceImpl extends AbsAgileDataProcess implements AgileDataProcessService {
    @Resource
    private ADEService adeService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private EchoService echoService;

    @Autowired
    private AgileReportDataService agileReportDataService;

    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        try {
            // 前置
            Map<String,Object> req = this.processBefore(event,responseData);
            // 后置
            this.processAfter(event,req,responseData);
        } catch (Exception e) {
            Map<String,Object> queryData = new HashMap<>();
            queryData.put("title",messageUtil.getMessageByLangNameWithFormat(
                    "message.sse.essentialFactor",event.getLang()));
            queryData.put("status",false);
            this.updateAIBoardDataByError(event,responseData.getData().getDataset().getProcessStreamData(),queryData);
            log.error("对话看板 获取解题思路失败: {}" , JsonUtils.objectToString(e));
            Thread.currentThread().interrupt();
        }
    }

    /**
     * 调用ade 前 前置输出要素识别等信息
     * @param event 上下文
     * @param responseData 语义返回
     * @return ade 入参
     */
    public Map<String,Object> processBefore(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        // 根据版本号V1 or V2 返回ADE请求入参
        Map<String,Object> req = this.parameterBasedOnVersion(responseData,event);
        // 更新对话看板要素识别信息
        this.updateProcessStreamDataByEF(event,req,responseData);
        return req;
    }

    /**
     * ade 返回消息后置处理
     * @param event 上下文
     * @param response 返回实体
     * @param responseData 语义返回实体
     */
    public void processAfter(AthenaMessageEvent event, Map<String,Object> response,QuerySchemaResDTO responseData) {
        if(Objects.isNull(response)){
            // 更新失败执行步骤 0 成功 1 失败 2 执行中
            log.info("更新对话看板执行步骤 ADE解题思路失败");
            this.updateAIBoardDataFile(event,responseData,1,null);
            return;
        }
        try{
            // 更新成功执行步骤
            this.updateAIBoardDataFile(event,responseData,0,response);
        }catch (Exception e){
            this.updateAIBoardDataFile(event,responseData,1,null);
        }
    }



    /**
     * 更新要素识别信息
     * @param event e
     * @param req r
     * @param responseData res
     */
    public void updateProcessStreamDataByEF(AthenaMessageEvent event,
                                            Map<String,Object> req,
                                            QuerySchemaResDTO responseData) {
        Map<String,Object> processStreamData = responseData.getData().getDataset().getProcessStreamData();
        log.info("对话看板 更新要素识别语义入参 processStreamData: {}",JsonUtils.objectToString(processStreamData));
        // sse 解题要素识别
        Map<String, Object> essentialFactor = new HashMap<>();
        essentialFactor.put("title","解题要素识别");
        Map<String, Object> response = adeService.getEssentialFactor(event,req);
        if(response == null || Objects.isNull(response.get("msg"))){
            assert response != null;
            essentialFactor.put("content",response.get("msg"));
            essentialFactor.put("status",false);
        }else{
            essentialFactor.put("content",response.get("data"));
            essentialFactor.put("status",true);
        }
        processStreamData.put("stepAnasisly",essentialFactor);
    }



    /**
     * 根据状态更新ppt执行步骤信息
     * @param event e
     * @param responseData re
     * @param status s
     */
    public void updateAIBoardDataFile(AthenaMessageEvent event,QuerySchemaResDTO responseData,Integer status,Map<String,Object> getDataParams) {
        AIBoardDTO aiBoardDTO = new AIBoardDTO();
        Map<String,Object> processStreamData = responseData.getData().getDataset().getProcessStreamData();
        aiBoardDTO.setMessageId(Long.valueOf(event.getMsgExt().get("aiBoardMessageId").toString()));
        List<AIBoardDTO.AIBoardQuestionDTO> questionDTOS = new ArrayList<>();
        AIBoardDTO.AIBoardQuestionDTO questionDTO = new AIBoardDTO.AIBoardQuestionDTO();
        questionDTO.setQuestionId(Long.valueOf(event.getMsgExt().get("aiBoardQuestionId").toString()));
        AIBoardDTO.AIBoardAnalyzeDTO analyzeDTO = JsonUtils.jsonToObject(
                JsonUtils.objectToString(processStreamData),AIBoardDTO.AIBoardAnalyzeDTO.class);
        questionDTO.setAnalyzeResult(analyzeDTO);
        questionDTO.setAnalyzeStatus(status);
        questionDTO.setAnalyzeMessageId(event.getGenerateSerialNo());
        questionDTO.setGetDataParams(getDataParams);
        questionDTOS.add(questionDTO);
        aiBoardDTO.setQuestionInfo(questionDTOS);
        log.info("更新对话看板执行步骤和状态入参 eventQuestionId :{},: data:{}",event.getGenerateSerialNo(),
                JsonUtils.objectToString(aiBoardDTO));
        echoService.updateAIBoard(aiBoardDTO,event.getUser().getToken(),event.getUser().getTenantId());
    }
}
