package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.AUTODATA_REPORT)
public class AgileDataProcessAutoDataReportServiceImpl implements AgileDataProcessService {

    @Autowired
    private EchoService echoService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private FileParsingService fileParsingService;

    @Autowired
    private DmcService dmcService;


    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        AgileDataAutoDataDTO agileDataAutoDataDTO = new AgileDataAutoDataDTO();
        Long messageId = MapUtils.getLong(event.getMsgExt(),"autoDataMessageId");
        agileDataAutoDataDTO.setMessageId(messageId);
        //获取可解析markdown
        Map<String,Object> processStreamData = querySchemaResDTO.getProcessStreamData();
        if(MapUtils.isEmpty(processStreamData)){
            //更新为处理失败
            agileDataAutoDataDTO.setStatus("1");
            echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
            SseEmitterUtils.sendAnswerDone(event.getSseEmitter(),false);
            return;
        }
        //历史消息存入dmc
        UploadParamDTO uploadParamDTO = new UploadParamDTO();
        uploadParamDTO.setFileJson(JsonUtils.objectToString(processStreamData));
        uploadParamDTO.setFileName(String.valueOf(messageId));
        UploadAttachmentResp uploadAttachmentResp = dmcService.uploadAgileData(uploadParamDTO,event.getUser());
        if(uploadAttachmentResp != null){
            agileDataAutoDataDTO.setShowDmcId(uploadAttachmentResp.getId());
        } else {
            //更新为处理失败
            agileDataAutoDataDTO.setStatus("1");
            echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
            SseEmitterUtils.sendAnswerDone(event.getSseEmitter(),false);
            return;
        }
        //更新状态
        agileDataAutoDataDTO.setStatus("0");
        echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
        //发送流式消息
        SseEmitterUtils.sendAnswerDone(event.getSseEmitter(),true);

    }

}
