package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.digiwin.athena.adt.agileReport.constant.BusinessConstants.VERSION_1;

/**
 * @Author: SunHong
 * @Date: 2025/5/19 10:38
 * @Description: 数据集
 */
@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.DATASET)
public class AgileDataProcessDatasetServiceImpl extends AbsAgileDataProcess implements AgileDataProcessService{

    @Resource
    private ADEService adeService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;

    @Autowired
    private EchoService echoService;

    @Autowired
    private AgileReportService agileReportService;

    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        try {
            // 前置
            Map<String,Object> req = this.processBefore(event,responseData);
            // 后置
            this.processAfter(event,req,responseData);
         } catch (Exception e) {
            Map<String, Object> msgBody = new HashMap<>();
            log.error("ade message sendMessageToAde error: {}" ,e.getMessage());
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            msgBody.put("prompt",tipMessage);
            this.saveAbnormal(event,tipMessage,0);
            semcService.sendMessageToGpt(event,msgBody);
            Thread.currentThread().interrupt();
        }
    }

    /**
     * 调用ade 前 前置输出要素识别等信息
     * @param event 上下文
     * @param responseData 语义返回
     * @return ade 入参
     * @throws ExecutionException e
     * @throws InterruptedException i
     */
    public Map<String,Object> processBefore(AthenaMessageEvent event, QuerySchemaResDTO responseData) throws ExecutionException, InterruptedException {
        AtomicBoolean state = new AtomicBoolean(false);
        CountDownLatch returnResultLatch = new CountDownLatch(1);
        String sseProductVersion = event.getSseProductVersion();
        // 根据版本号V1 or V2 返回ADE请求入参
        Map<String,Object> req = this.parameterBasedOnVersion(responseData,event);
        if(event.isSseMessage()){
            EventData.EventMessage eventMessage;
            log.info("send 要素识别会话开始");
            Map<String ,Object> messageObj = new HashMap<>();
            // 解析要素识别
            String messageTitle = messageUtil
                    .getMessageByLangNameWithFormat("message.sse.essentialFactor", event.getLang());
            messageObj.put("name",messageTitle);
            messageObj.put("arguments ",new HashMap<>());
            if(VERSION_1.equals(sseProductVersion)){
                eventMessage = EventData.EventMessage.builderNewEventMessage(
                        "function_call",messageObj,event);
            }else{
                eventMessage = EventData.EventMessage.builderNewEventMessageV2(
                        "function_call",messageTitle,event);
            }
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),event.getSseEmitter(),eventMessage);
        }
        CompletableFuture<Boolean> getEssentialFactor = CompletableFuture.supplyAsync(() -> {
            AppAuthContextHolder.clearContext();
            log.info("initMdc getEssentialFactor : traceId : {},mdc get ptxId :{},event PtxId :{}", MDC.get("traceId"),MDC.get("PtxId"),event.getPtxId());
            MDC.put("traceId", event.getPtxId());
            MDC.put("PtxId", event.getPtxId());
            JaMDC.put(event.getPtxId());
            // sse 解题要素识别
            this.getEssentialFactorAndSendSseMessage(event,req,state,returnResultLatch);
            returnResultLatch.countDown();
            return true;
        });
        CompletableFuture<Map<String,Object>> adeResult = CompletableFuture.supplyAsync(() -> {
            AppAuthContextHolder.clearContext();
            log.info("initMdc reqMetricSnapShotData : traceId : {},mdc get ptxId :{},event PtxId :{}", MDC.get("traceId"),MDC.get("PtxId"),event.getPtxId());
            log.info("initMdc getEssentialFactor : traceId : {},mdc get ptxId :{},event PtxId :{}", MDC.get("traceId"),MDC.get("PtxId"),event.getPtxId());
            MDC.put("traceId", event.getPtxId());
            MDC.put("PtxId", event.getPtxId());
            JaMDC.put(event.getPtxId());
            Map<String, Object> res = adeService.reqMetricSnapShotData(req, event);
            state.set(true);
            try {
                boolean awaitResult = returnResultLatch.await(60, TimeUnit.SECONDS);
                if(awaitResult){
                    log.info("Condition is satisfied");
                }else{
                    log.info("Condition is not satisfied");
                }
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
//                throw new RuntimeException(e);
            }
            if(res == null || MapUtils.getMap(res, "data") == null) {
                if(event.isSseMessage()){
                    EventData.EventMessage toolResponse;
                    if(VERSION_1.equals(sseProductVersion)){
                        toolResponse = EventData.EventMessage.builderMessageClose(
                                "tool_response",event.getSseCallId(),"fail");
                    }else{
                        toolResponse = EventData.EventMessage.builderMessageCloseV2(
                                "tool_response",event.getSseCallId(),"fail");
                    }
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),event.getSseEmitter(),toolResponse);
                }
                String errorMsg = MapUtils.getString(res, "msg");
                Map<String,Object> sendMap = Maps.newHashMap();
                sendMap.put("prompt", errorMsg);
                //记录异常日志
                String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang());
                this.saveAbnormal(event, tipMessage, 0);
                // 非计费正常发送娜娜
                semcService.sendMessageToGpt(event,sendMap);
                return null;
            }
            return res;
        });
        getEssentialFactor.get();
        log.info("send 取数结束");
        if(event.isSseMessage()){
            EventData.EventMessage toolResponse;
            if(VERSION_1.equals(sseProductVersion)){
                toolResponse = EventData.EventMessage.builderMessageClose(
                        "tool_response",event.getSseCallId(),"success");
            }else{
                toolResponse = EventData.EventMessage.builderMessageCloseV2(
                        "tool_response",event.getSseCallId(),"success");
            }
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(),event.getSseEmitter(),toolResponse);
        }
        return adeResult.get();
    }

    /**
     * ade 返回消息后置处理
     * @param event 上下文
     * @param response 返回实体
     * @param responseData 语义返回实体
     */
    public void processAfter(AthenaMessageEvent event, Map<String,Object> response,QuerySchemaResDTO responseData) {
        if(Objects.isNull(response)){
            return;
        }
        String question = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        try{
            Map<String,Object> sendMap = Maps.newHashMap();
            Map<String,Object> data = MapUtils.getMap(response, "data");
            // 大数据量优化呈现
            Pair<Boolean, Integer> interception = isDataProcessAction(data);
            if(interception.getLeft()){
                echoService.echoMongodbSubmit(EchoSubmitReq.builderInterception(event, messageUtil,interception.getRight())
                        ,event.getUser().getToken(),event.getUser().getTenantId());
            }
            String snapshotId = MapUtils.getString(data, "snapshotId");
            sendMap.put("snapshotId",snapshotId);
            //指标要素识别信息
            this.executeStepAnalysis(event,response);
            // 数据总结标识
            this.setDataSummary(data,event);
            // 数据筛选
            this.setDataScreening(event,response);
            //图表转换信息
            AgileDataAnalysisUtils.getTransShowInfo(data,sendMap,null);
            //转换业务数据，存入历史i消息
            agileReportService.executeAgileDataByTokenSize(event.getUser(),event, data);
            // 记录问答
            this.saveQuestionData(MapUtils.getMap(response, "data"),event,question,combinationQuestion,generateSerialNo);
            // 分类关系
            this.saveBuiltClassifications(event,response);
            if(StringUtils.isNotEmpty(snapshotId)){
                // 保存计费平台数据
                agileDataCostDetailService.saveAgileDataCostDetail(data,event.getUser(),event.getPtxId()
                        ,event.getAppCode(),event.getAppName(),event.getSourceName());
            }
            // 计费组合实现 返回false 记录日志和娜娜 - 根据上下文是否发送娜娜字段判断
            boolean isCheck = agileDataCalculateCostService.combinedBillingCalculation(event,data,sendMap);
            if(!isCheck){
                return;
            }
            // 非计费正常发送娜娜
            semcService.sendMessageToGpt(event,sendMap);
        }catch (Exception e){
            Map<String,Object> sendMap = Maps.newHashMap();
            sendMap.put("prompt",e.getMessage());
            //记录异常日志
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            semcService.sendMessageToGpt(event,sendMap);
            this.saveAbnormal(event,tipMessage,0);
        }
    }
}
