package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.*;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.SnapDataInfoDTO;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.KMScencDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/6/3 13:38
 * @Description: 执行问句-设计器
 */
@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.DESIGNER)
public class AgileDataProcessDesignerServiceImpl extends AbsAgileDataProcess implements AgileDataProcessService {

    @Resource
    private ADEService adeService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private KmService kmService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;

    @Autowired
    private EchoService echoService;

    @Autowired
    private AgileReportService agileReportService;

    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    @Autowired
    private SnapShotDataService snapShotDataService;

    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {

        //模拟快照,压测用
        String snapId = MapUtils.getString(event.getMsgBody(),"snapshotId",null);
        if(!StringUtils.isEmpty(snapId)){
            log.info("快照ID：{},处理开始时间：{}",snapId, TimeUtils.format(new Date(),"yyyy-MM-dd HH:mm:ss:SSS"));
        }
        String question = event.getQuestion();
        //记录全链路日志
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(),question, JsonUtils.objectToString(event.getMsgBody()));
        LogDto logDto = new LogDto("获取意图识别数据：" + JsonUtils.objectToString(responseData));
        log.info(logDto.toString());
        try{
            for (Map<String, Object> data : responseData.getData().getDataflow()) {
                if (Objects.nonNull(data.get("code")) && (int) data.get("code") == 1) {
                    String kmCode = getKmCodeByEventOrSchemaData(event,data);
                    ADEScencDTO adeScencDTO = buildCommonAdeScene(event,data);
                    //从KM获取场景code
                    Map<String, Object> sceneMap = Maps.newHashMap();
                    sceneMap.put("templateCode", adeScencDTO.getTemplateCode());
                    sceneMap.put("targetId", adeScencDTO.getTarget());
                    sceneMap.put("dimension", adeScencDTO.getDimension());
                    //记录全链路日志
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，获取KM场景，入参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                            , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(sceneMap));
                    //记录全链路日志
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，获取KM场景，出参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                            , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(event.getScenes()));
                    //场景不存在，反馈异常信息
                    if (StringUtils.isEmpty(kmCode)) {
                        Map<String, Object> errorMap = Maps.newHashMap();
                        errorMap.put("message", "场景不存在");
                        this.saveQuerySchemaErrorByCode(event,null);
                        continue;
                    }
                    adeScencDTO.setSceneCode(kmCode);
                    Map<String, Object> recastData = new HashMap<>();
                    recastData.put(kmCode, data.get("data"));
                    adeScencDTO.setRecast(recastData);
                    // 请求ade and km
                    this.sendMessageToAde(event,adeScencDTO);
                    // 保存计费平台数据
                    agileDataCostDetailService.saveAgileDataCostDetail(data,event.getUser(),event.getPtxId()
                            ,event.getAppCode(),event.getAppName(),event.getSourceName());
                } else {
                    Map<String, Object> msgBody = new HashMap<>();
                    msgBody.put("prompt", MapUtils.getString(data, "data"));
                    Object obj = MapUtils.getObject(data,"sentences",null);
                    event.setAnswerResult(2);
                    if(obj instanceof Collection){
                        event.setSentences(CommonUtil.objConvertListString(obj));
                    }
                    this.saveAbnormalLog(event,MapUtils.getString(data, "data"),1,0);
                    semcService.sendMessageToGpt(event,msgBody);
                }
            }
        }catch (Exception e){
            log.error("agiledata_ADT AgileDataProcessDesignerServiceImpl Exception : {}",e.getMessage());
            Map<String, Object> errorMap = Maps.newHashMap();
            errorMap.put("message", JsonUtils.objectToString(e.getMessage()));
            this.saveQuerySchemaErrorByCode(event,null);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句出参：{},耗时:{}ms",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(),question,JsonUtils.objectToString(event.getMsgBody()),System.currentTimeMillis() - getQuerySchemaTook);
    }

    /** ade 和 km 后续链路
     * @param adeScencDTO ade入参
     * @param event 上下文
     */
    public void sendMessageToAde(AthenaMessageEvent event,ADEScencDTO adeScencDTO){
        AuthoredUser user = event.getUser();
        String question = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        Map<String, Object> response = new HashMap<>();
        try {
            List<String> relatedIntentions = new ArrayList<>();
            //模拟快照,压测用
            String snapId = MapUtils.getString(event.getMsgBody(),"snapshotId",null);
            if(StringUtils.isNotEmpty(snapId)){
                adeScencDTO.setSnapshotId(snapId);
            }
            response = adeService.getRealtimeSnapShotData(user, adeScencDTO,event);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", LogUtils.SUCCESS,
                    JsonUtils.objectToString(response),"", "");
            Map<String, Object> data = MapUtils.getMap(response, "data");

            Map<String,Object> sendMap = Maps.newHashMap();
            if (data != null) {
                // 大数据量优化呈现
                Pair<Boolean, Integer> interception = isDataProcessAction(data);
                if(interception.getLeft()){
                    echoService.echoMongodbSubmit(EchoSubmitReq.builderInterception(event, messageUtil,interception.getRight())
                            ,event.getUser().getToken(),event.getUser().getTenantId());
                }
                String snapshotId = MapUtils.getString(data, "snapshotId");
                sendMap.put("snapshotId",snapshotId);
                // querySchemaNoGPT 成功请求 ade 入参
                event.setAdeScencDTO(adeScencDTO);
                Integer defaultShowType =  AgileDataAnalysisUtils.getSceneDefaultShowType( data);
                if(defaultShowType == 1) {
                    SnapDataInfoDTO snapDataInfoDTO = snapShotDataService.getSnapDataInfoBySnapshotId(user.getTenantId(), user.getUserId(), snapshotId);
                    if (snapDataInfoDTO != null) {
                        defaultShowType = echoService.getSceneShowType(snapDataInfoDTO, user.getToken(), user.getTenantId());
                    }
                }
                //图表转换呈现信息
                AgileDataAnalysisUtils.getTransShowInfo(data,sendMap,defaultShowType);
            } else {
                String errorMsg = MapUtils.getString(response, "msg");
                sendMap.put("prompt",errorMsg);
                //记录异常日志
                String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
//                sendMap.put("prompt",tipMessage);
                this.saveAbnormal(event,tipMessage,0);
            }
            //根据sceneCode获取相关推荐
            if(StringUtils.isNotEmpty(adeScencDTO.getSceneCode())) {
                long getKmTookTime = System.currentTimeMillis();
                KMScencDTO kmScencDTO = kmService.getKmSceneInfo(event,adeScencDTO.getSceneCode(),event.getLang(),user.getToken(),user.getTenantId());
                long kmTook = System.currentTimeMillis() - getKmTookTime;
                log.info("shouldSentToAde.sendMessageToAde -> getKmSceneInfo took:{}", kmTook);
                if(kmScencDTO != null && StringUtils.isNotEmpty(kmScencDTO.getRelatedIntentions())){
                    relatedIntentions = Arrays.asList(kmScencDTO.getRelatedIntentions().split(";"));
                    sendMap.put("intentions",relatedIntentions);
                    event.setAnswerResult(1);
                    event.setSentences(relatedIntentions);
                }
            }
            //转换业务数据
            agileReportService.executeAgileDataByTokenSize(user,event, data);
            // 分类关系
            this.saveBuiltClassifications(event,response);
            //记录问答数据
            this.saveQuestionData(data,event,question,combinationQuestion,generateSerialNo);
            //模拟快照,压测用
            if(StringUtils.isNotEmpty(snapId)){
                log.info("快照ID：{},处理结束时间：{}",snapId, TimeUtils.format(new Date(),"yyyy-MM-dd HH:mm:ss:SSS"));
            }
            // 计费组合实现 返回false 记录日志和娜娜 - 根据上下文是否发送娜娜字段判断
            boolean isCheck = agileDataCalculateCostService.combinedBillingCalculation(event,data,sendMap);
            if(!isCheck){
                return;
            }
            // 非计费流程正常发送娜娜
            semcService.sendMessageToGpt(event,sendMap);
        } catch (Exception e) {
            Map<String, Object> msgBody = new HashMap<>();
            log.error("ade message sendMessageToAde error: {}" ,e.getMessage());
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            msgBody.put("prompt",tipMessage);
            this.saveAbnormal(event,tipMessage,0);
            semcService.sendMessageToGpt(event,msgBody);
        }
    }
}
