package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.PPT_ANALYZE)
public class AgileDataProcessPPTAnalyzeServiceImpl implements AgileDataProcessService {

    @Autowired
    private EchoService echoService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        AgileDataFileDTO agileDataFileDTO = AgileDataAnalysisUtils.buildAgileDataFile(event.getGenerateSerialNo(),event.getAppCode(), querySchemaResDTO);
        Boolean result =  echoService.addAgileDataFile(agileDataFileDTO, event.getUser().getToken(), event.getUser().getTenantId());
        Map<String,Object> msgBody = Maps.newHashMap();
        if(result){
            msgBody.put("analyzeResult",true);
            msgBody.put("measures",event.getQuestionPlanningRes().getMeasures());

        } else {
            msgBody.put("analyzeResult",false);
            String sysError = messageUtil.getMessageByLangNameWithFormat(
                    "message.system.ppt.schema.error",event.getLang());
            msgBody.put("prompt", sysError);
        }
        semcService.sendMessageToGpt(event, msgBody);
    }


}
